/*
 * Decompiled with CFR 0.152.
 */
package com.github.lontime.base.commonj.domain;

import com.github.lontime.base.commonj.errors.ErrorCodeEnum;
import com.github.lontime.base.commonj.errors.ErrorMessage;
import com.github.lontime.base.commonj.errors.ErrorTypes;
import java.util.Optional;

public class BaseOutbound {
    private Integer status;
    private String code;
    private String message;
    private String details;

    public static <T extends BaseOutbound> T create(T instance) {
        return BaseOutbound.create(instance, ErrorCodeEnum.SUCCESS);
    }

    public static <T extends BaseOutbound> T create(T instance, ErrorCodeEnum codeEnum) {
        return BaseOutbound.create(instance, codeEnum, null);
    }

    public static <T extends BaseOutbound> T create(T instance, ErrorCodeEnum codeEnum, String message) {
        ErrorMessage errorMessage = ErrorTypes.detectErrorType(codeEnum);
        instance.setCode(errorMessage.getCode());
        instance.setMessage(Optional.ofNullable(message).orElse(errorMessage.getMessage()));
        instance.setStatus(errorMessage.getStatusCode());
        return instance;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDetails() {
        return this.details;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public String toString() {
        return "BaseOutbound(status=" + this.getStatus() + ", code=" + this.getCode() + ", message=" + this.getMessage() + ", details=" + this.getDetails() + ")";
    }
}

