/*
 * Decompiled with CFR 0.152.
 */
package com.github.lontime.base.commonj.config;

import com.github.lontime.base.commonj.config.CommonOptions;
import com.github.lontime.base.commonj.config.ExecutorKind;
import com.github.lontime.base.commonj.config.NamedCommonExecutorOptions;
import com.github.lontime.base.commonj.utils.SupplierHelper;
import com.github.lontime.extconfig.ConfigHelper;
import com.github.lontime.shaded.io.helidon.config.Config;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public class CommonOptionResolver {
    private static final String NAME = "common";
    private static Supplier<CommonOptionResolver> supplier = SupplierHelper.memoize(CommonOptionResolver::new);
    private CommonOptions options = (CommonOptions)ConfigHelper.resolve((String)"common").as((Function)new Mapper()).orElse((Object)CommonOptions.DEFAULT);

    public static CommonOptionResolver getInstance() {
        return supplier.get();
    }

    private CommonOptionResolver() {
    }

    public List<NamedCommonExecutorOptions> getExecutors() {
        return this.options.getExecutors();
    }

    public NamedCommonExecutorOptions getExecutor(String name) {
        return this.getExecutors().stream().filter(e -> Objects.nonNull(e.getName())).filter(e -> e.getName().equals(name)).findFirst().orElse(null);
    }

    public Duration getAwaitRunningTimeout() {
        return this.options.getAwaitRunningTimeout();
    }

    public Duration getAwaitTerminatedTimeout() {
        return this.options.getAwaitTerminatedTimeout();
    }

    public Duration getTransientResponseTimeout() {
        return this.options.getTransientResponseTimeout();
    }

    static class ExecutorMapper
    implements Function<Config, NamedCommonExecutorOptions> {
        ExecutorMapper() {
        }

        @Override
        public NamedCommonExecutorOptions apply(Config config) {
            NamedCommonExecutorOptions executorOptions = new NamedCommonExecutorOptions();
            executorOptions.setName(config.key().name());
            config.get("corePoolSize").asInt().ifPresent(executorOptions::setCorePoolSize);
            config.get("maxPoolSize").asInt().ifPresent(executorOptions::setMaxPoolSize);
            config.get("keepAliveTime").asString().map(Duration::parse).ifPresent(executorOptions::setKeepAliveTime);
            config.get("allowCoreThreadTimeOut").asBoolean().ifPresent(executorOptions::setAllowCoreThreadTimeOut);
            config.get("queue").asInt().ifPresent(executorOptions::setQueue);
            config.get("rejectedStrategy").asString().ifPresent(executorOptions::setRejectedStrategy);
            config.get("threadFactory").asNode().map(this::threadFactory).ifPresent(executorOptions::setThreadFactory);
            config.get("kind").asString().map(String::toUpperCase).map(s -> ExecutorKind.valueOf(s)).ifPresent(executorOptions::setKind);
            return executorOptions;
        }

        private NamedCommonExecutorOptions.ThreadFactory threadFactory(Config config) {
            NamedCommonExecutorOptions.ThreadFactory threadFactory = new NamedCommonExecutorOptions.ThreadFactory();
            config.get("prefix").asString().ifPresent(threadFactory::setPrefix);
            config.get("groupName").asString().ifPresent(threadFactory::setGroupName);
            config.get("hasDaemon").asBoolean().ifPresent(threadFactory::setDaemon);
            config.get("uncaughtExceptionStrategy").asString().ifPresent(threadFactory::setUncaughtExceptionStrategy);
            return threadFactory;
        }
    }

    static class Mapper
    implements Function<Config, CommonOptions> {
        Mapper() {
        }

        @Override
        public CommonOptions apply(Config config) {
            CommonOptions options = new CommonOptions();
            config.get("awaitRunningTimeout").asString().map(Duration::parse).ifPresent(options::setAwaitRunningTimeout);
            config.get("awaitTerminatedTimeout").asString().map(Duration::parse).ifPresent(options::setAwaitTerminatedTimeout);
            config.get("transientResponseTimeout").asString().map(Duration::parse).ifPresent(options::setTransientResponseTimeout);
            config.get("executors").asList((Function)new ExecutorMapper()).ifPresent(options::setExecutors);
            return options;
        }
    }
}

