/*
 * Decompiled with CFR 0.152.
 */
package com.github.lontime.base.commonj.concurrent;

import com.github.lontime.base.commonj.concurrent.DataWithId;
import com.github.lontime.base.commonj.concurrent.EmptyResponse;
import com.github.lontime.base.commonj.concurrent.EmptyResponseFactory;
import com.github.lontime.base.commonj.concurrent.Response;
import com.github.lontime.base.commonj.concurrent.ResponseFactory;
import com.github.lontime.base.commonj.utils.CollectionHelper;
import com.github.lontime.base.commonj.utils.LoggerHelper;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public abstract class TransientResponseHelper {
    public static <T> T awaitAndGet(String id) {
        return TransientResponseHelper.awaitAndGet(id, null);
    }

    public static void await(String id) {
        TransientResponseHelper.await(id, null);
    }

    public static <T> T awaitAndGet(String id, Duration timeout) {
        List<T> results = TransientResponseHelper.awaitAndGetBatch(Arrays.asList(id), timeout);
        if (CollectionHelper.isEmpty(results)) {
            return null;
        }
        return results.get(0);
    }

    public static void await(String id, Duration timeout) {
        TransientResponseHelper.awaitBatch(Arrays.asList(id), timeout);
    }

    public static <T> List<T> awaitAndGetBatch(List<String> ids) {
        return TransientResponseHelper.awaitAndGetBatch(ids, null);
    }

    public static void awaitBatch(List<String> ids) {
        TransientResponseHelper.awaitBatch(ids, null);
    }

    public static <T> List<T> awaitAndGetBatch(List<String> ids, Duration timeout) {
        List<Mono<DataWithId<T>>> monos = TransientResponseHelper.asyncAndGetBatch(ids, timeout);
        List results = monos.stream().map(s -> {
            try {
                return (DataWithId)s.block();
            }
            catch (Exception e) {
                LoggerHelper.warnv((Throwable)e, "awaitAndGetBatch is error", new Object[0]);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionHelper.isEmpty(results)) {
            return Collections.emptyList();
        }
        ResponseFactory.get().remove(results.stream().map(s -> s.getId()).collect(Collectors.toList()));
        return results.stream().map(s -> s.getData()).collect(Collectors.toList());
    }

    public static void awaitBatch(List<String> ids, Duration timeout) {
        List<Mono<DataWithId<Object>>> monos = TransientResponseHelper.asyncBatch(ids, timeout);
        List<String> results = monos.stream().map(s -> {
            try {
                DataWithId dataWithId = (DataWithId)s.block();
                if (dataWithId != null) {
                    return dataWithId.getId();
                }
            }
            catch (Exception e) {
                LoggerHelper.warnv((Throwable)e, "awaitBatch is error", new Object[0]);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionHelper.isEmpty(results)) {
            return;
        }
        EmptyResponseFactory.get().remove(results);
    }

    public static <T> Mono<T> asyncAndGet(String id, Duration timeout) {
        List<Mono<DataWithId<T>>> monos = TransientResponseHelper.asyncAndGetBatch(Arrays.asList(id), timeout);
        return monos.get(0).map(s -> s.getData());
    }

    public static Mono<Object> async(String id, Duration timeout) {
        List<Mono<DataWithId<Object>>> monos = TransientResponseHelper.asyncBatch(Arrays.asList(id), timeout);
        return monos.get(0).map(s -> s.getData());
    }

    public static <T> List<Mono<DataWithId<T>>> asyncAndGetBatch(List<String> ids, Duration timeout) {
        return ids.stream().map(s -> {
            Response response = ResponseFactory.get().getOrCreate((String)s, timeout);
            return Mono.fromCallable(() -> {
                Object data = response.call();
                if (data == null) {
                    return null;
                }
                return new DataWithId((String)s, data);
            }).subscribeOn(Schedulers.boundedElastic());
        }).collect(Collectors.toList());
    }

    public static List<Mono<DataWithId<Object>>> asyncBatch(List<String> ids, Duration timeout) {
        return ids.stream().map(s -> {
            EmptyResponse response = EmptyResponseFactory.get().getOrCreate((String)s, timeout);
            return Mono.fromCallable(() -> {
                if (response.run()) {
                    return new DataWithId<Object>((String)s, null);
                }
                return null;
            }).subscribeOn(Schedulers.boundedElastic());
        }).collect(Collectors.toList());
    }

    public static <T> boolean notify(String id, T data) {
        return ResponseFactory.get().send(id, data);
    }

    public static boolean notify(String id) {
        return EmptyResponseFactory.get().send(id);
    }
}

