/*
 * Decompiled with CFR 0.152.
 */
package com.github.lontime.base.commonj.concurrent;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.lontime.base.commonj.concurrent.Response;
import com.github.lontime.base.commonj.config.CommonOptionResolver;
import com.github.lontime.base.commonj.utils.SupplierHelper;
import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;

class ResponseFactory {
    private static Supplier<ResponseFactory> supplier = SupplierHelper.memoize(ResponseFactory::new);
    private Cache<String, Response<?>> cache = Caffeine.newBuilder().expireAfterWrite(CommonOptionResolver.getInstance().getTransientResponseTimeout()).build();

    ResponseFactory() {
    }

    public static ResponseFactory get() {
        return supplier.get();
    }

    public <T> Response<T> getOrCreate(String id) {
        return (Response)this.cache.get((Object)id, key -> new Response((String)key));
    }

    public <T> Response<T> getOrCreate(String id, Duration timeout) {
        return (Response)this.cache.get((Object)id, key -> new Response((String)key, timeout));
    }

    public void remove(List<String> ids) {
        this.cache.invalidateAll(ids);
    }

    public <T> boolean send(String id, T data) {
        return this.getOrCreate(id).send(data);
    }

    public int size() {
        this.cache.cleanUp();
        return (int)this.cache.estimatedSize();
    }
}

