/*
 * Decompiled with CFR 0.152.
 */
package com.github.lontime.base.commonj.concurrent;

import com.github.lontime.base.commonj.utils.Holder;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class Response<T>
implements Callable<T> {
    private CountDownLatch latch = new CountDownLatch(1);
    private Holder<T> responseHolder = new Holder();
    private String id;
    private Duration timeout;

    public Response(String id) {
        this(id, null);
    }

    public Response(String id, Duration timeout) {
        this.id = id;
        this.timeout = timeout;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public T call() throws Exception {
        if (this.timeout != null) {
            if (!this.latch.await(this.timeout.toNanos(), TimeUnit.NANOSECONDS)) {
                return null;
            }
        } else {
            this.latch.await();
        }
        return this.responseHolder.get();
    }

    public synchronized boolean send(T response) {
        if (this.latch.getCount() == 0L || response == null) {
            return false;
        }
        this.responseHolder.set(response);
        this.latch.countDown();
        return true;
    }
}

