/*
 * Decompiled with CFR 0.152.
 */
package com.github.lontime.base.commonj.concurrent;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.lontime.base.commonj.concurrent.EmptyResponse;
import com.github.lontime.base.commonj.config.CommonOptionResolver;
import com.github.lontime.base.commonj.utils.SupplierHelper;
import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;

class EmptyResponseFactory {
    private static Supplier<EmptyResponseFactory> supplier = SupplierHelper.memoize(EmptyResponseFactory::new);
    private Cache<String, EmptyResponse> cache = Caffeine.newBuilder().expireAfterWrite(CommonOptionResolver.getInstance().getTransientResponseTimeout()).build();

    EmptyResponseFactory() {
    }

    public static EmptyResponseFactory get() {
        return supplier.get();
    }

    public EmptyResponse getOrCreate(String id) {
        return (EmptyResponse)this.cache.get((Object)id, key -> new EmptyResponse((String)key));
    }

    public EmptyResponse getOrCreate(String id, Duration timeout) {
        return (EmptyResponse)this.cache.get((Object)id, key -> new EmptyResponse((String)key, timeout));
    }

    public void remove(List<String> ids) {
        this.cache.invalidateAll(ids);
    }

    public boolean send(String id) {
        return this.getOrCreate(id).send();
    }

    public int size() {
        this.cache.cleanUp();
        return (int)this.cache.estimatedSize();
    }
}

