/*
 * Decompiled with CFR 0.152.
 */
package com.github.lontime.base.commonj.concurrent;

import com.github.lontime.base.commonj.utils.LoggerHelper;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class EmptyResponse {
    private CountDownLatch latch = new CountDownLatch(1);
    private String id;
    private Duration timeout;

    public EmptyResponse(String id) {
        this(id, null);
    }

    public EmptyResponse(String id, Duration timeout) {
        this.id = id;
        this.timeout = timeout;
    }

    public String getId() {
        return this.id;
    }

    public boolean run() {
        try {
            if (this.timeout != null) {
                return this.latch.await(this.timeout.toNanos(), TimeUnit.NANOSECONDS);
            }
            this.latch.await();
            return true;
        }
        catch (InterruptedException e) {
            LoggerHelper.warnv((Throwable)e, "EmptyResponse is error", new Object[0]);
            return false;
        }
    }

    public synchronized boolean send() {
        if (this.latch.getCount() == 0L) {
            return false;
        }
        this.latch.countDown();
        return true;
    }
}

