/*
 * Decompiled with CFR 0.152.
 */
package com.github.lontime.base.commonj.components;

import com.github.lontime.base.commonj.utils.AssertHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class ListenerRegistry {
    private static Map<Class<?>, Set<Object>> map = new ConcurrentHashMap();

    ListenerRegistry() {
    }

    public static void set(Class<?> clazz, Object object) {
        map.computeIfAbsent(clazz, key -> Collections.synchronizedSet(new HashSet())).add(object);
    }

    public static void setIterable(Class<?> clazz, Iterable<Object> objects) {
        objects.forEach(s -> ListenerRegistry.set(clazz, s));
    }

    public static <T> List<T> get(Class<?> clazz) {
        AssertHelper.checkIfNull(clazz);
        if (!map.containsKey(clazz)) {
            return Collections.emptyList();
        }
        Set<Object> objects = map.get(clazz);
        ArrayList<Object> list = new ArrayList<Object>(objects.size());
        for (Object o : objects) {
            list.add(o);
        }
        return Collections.unmodifiableList(list);
    }
}

