/*
 * Decompiled with CFR 0.152.
 */
package com.github.lontime.base.commonj.components;

import com.github.lontime.base.commonj.components.ListenerRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public interface ListenableObject {
    public String getName();

    default public List<String> getNames() {
        String name = this.getName();
        if (name == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(name);
    }

    default public Class<?> getClazz() {
        return this.getClass();
    }

    default public void register(ListenableObject o1) {
        ListenerRegistry.set(this.getClazz(), o1);
    }

    default public void register(ListenableObject o1, ListenableObject o2) {
        ListenerRegistry.setIterable(this.getClazz(), Arrays.asList(o1, o2));
    }

    default public void register(ListenableObject o1, ListenableObject o2, ListenableObject o3) {
        ListenerRegistry.setIterable(this.getClazz(), Arrays.asList(o1, o2, o3));
    }

    default public void register(ListenableObject o1, ListenableObject o2, ListenableObject o3, ListenableObject o4) {
        ListenerRegistry.setIterable(this.getClazz(), Arrays.asList(o1, o2, o3, o4));
    }

    default public void register(ListenableObject o1, ListenableObject o2, ListenableObject o3, ListenableObject o4, ListenableObject o5) {
        ListenerRegistry.setIterable(this.getClazz(), Arrays.asList(o1, o2, o3, o4, o5));
    }

    default public void register(List<ListenableObject> objects) {
        ListenerRegistry.setIterable(this.getClazz(), objects.stream().map(s -> s).collect(Collectors.toList()));
    }

    default public <T extends ListenableObject> List<T> getListeners() {
        return ListenerRegistry.get(this.getClazz());
    }

    default public <T extends ListenableObject> List<T> getListeners(String name) {
        if (name == null) {
            return Collections.emptyList();
        }
        List<T> objects = this.getListeners();
        return objects.stream().filter(s -> s.getNames().contains(name)).collect(Collectors.toList());
    }
}

