/*
 * Decompiled with CFR 0.152.
 */
package com.github.lontime.base.commonj.components;

import com.github.lontime.base.commonj.components.ComponentInterface;
import com.github.lontime.base.commonj.components.ListenerRegistry;
import com.github.lontime.base.commonj.utils.CollectionHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ComponentInterfaceHelper {
    public static <T extends ComponentInterface> void register(T o1) {
        ComponentInterfaceHelper.register(Arrays.asList(o1));
    }

    public static <T extends ComponentInterface> void register(T o1, T o2) {
        ComponentInterfaceHelper.register(Arrays.asList(o1, o2));
    }

    public static <T extends ComponentInterface> void register(T o1, T o2, T o3) {
        ComponentInterfaceHelper.register(Arrays.asList(o1, o2, o3));
    }

    public static <T extends ComponentInterface> void register(T o1, T o2, T o3, T o4) {
        ComponentInterfaceHelper.register(Arrays.asList(o1, o2, o3, o4));
    }

    public static <T extends ComponentInterface> void register(T o1, T o2, T o3, T o4, T o5) {
        ComponentInterfaceHelper.register(Arrays.asList(o1, o2, o3, o4, o5));
    }

    public static <T extends ComponentInterface> void register(T o1, T o2, T o3, T o4, T o5, T o6) {
        ComponentInterfaceHelper.register(Arrays.asList(o1, o2, o3, o4, o5, o6));
    }

    public static <T extends ComponentInterface> void register(List<T> objects) {
        if (CollectionHelper.isEmpty(objects)) {
            return;
        }
        ListenerRegistry.setIterable(((ComponentInterface)objects.get(0)).getClazz(), objects.stream().map(s -> s).collect(Collectors.toList()));
    }

    public static <T extends ComponentInterface> List<T> getAll(Class<T> clazz) {
        return ListenerRegistry.get(clazz);
    }

    public static <T extends ComponentInterface> List<T> get(Class<T> clazz, String name) {
        if (name == null) {
            return Collections.emptyList();
        }
        List<T> objects = ComponentInterfaceHelper.getAll(clazz);
        return objects.stream().filter(s -> s.getNames().contains(name)).collect(Collectors.toList());
    }

    public static <T extends ComponentInterface> Optional<T> getOnly(Class<T> clazz, String name) {
        List<T> interfaces = ComponentInterfaceHelper.get(clazz, name);
        if (CollectionHelper.isEmpty(interfaces)) {
            return Optional.empty();
        }
        return Optional.of(interfaces.get(0));
    }
}

