/*
 * Decompiled with CFR 0.152.
 */
package com.github.lontime.base.commonj.components;

import com.github.lontime.base.commonj.components.ComponentLifecycle;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class ActiveComponents {
    private static final Map<String, ComponentLifecycle> compenents = new ConcurrentHashMap<String, ComponentLifecycle>();

    public static void add(ComponentLifecycle component) {
        compenents.put(component.getName(), component);
    }

    public static ComponentLifecycle remove(ComponentLifecycle component) {
        return compenents.remove(component.getName());
    }

    public static List<ComponentLifecycle> getAll() {
        return compenents.values().stream().sorted(Comparator.comparingInt(ComponentLifecycle::getStartupPriority)).collect(Collectors.toList());
    }

    public static int size() {
        return compenents.size();
    }
}

