/*
 * Decompiled with CFR 0.152.
 */
package com.github.lontime.base.commonj.components;

import com.github.lontime.base.commonj.components.AbstractLifecycle;
import com.github.lontime.base.commonj.utils.Holder;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class AbstractStatefulLifecycle
extends AbstractLifecycle {
    private Holder<Boolean> alive = Holder.of(false);
    private ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();

    @Override
    public void start() {
        this.rwl.writeLock().lock();
        try {
            this.alive.set(true);
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @Override
    public void stop() {
        this.rwl.writeLock().lock();
        try {
            this.alive.set(false);
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public boolean isAlive() {
        this.rwl.readLock().lock();
        try {
            boolean bl = this.alive.get();
            return bl;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }
}

