/*
 * Decompiled with CFR 0.152.
 */
package com.github.lontime.base.commonj.components;

import com.github.lontime.base.commonj.components.ActiveComponents;
import com.github.lontime.base.commonj.components.ComponentLifecycle;
import com.github.lontime.base.commonj.components.ComponentLock;
import com.github.lontime.base.commonj.components.ComponentShutdownPriority;
import com.github.lontime.base.commonj.components.ComponentState;
import com.github.lontime.base.commonj.config.CommonOptionResolver;
import com.github.lontime.base.commonj.langs.ExtPriorityHook;
import com.github.lontime.base.commonj.langs.Hooklet;
import com.github.lontime.base.commonj.utils.CommonManager;
import com.github.lontime.base.commonj.utils.LoggerHelper;
import java.time.Duration;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractComponentLifecycle
implements ComponentLifecycle {
    private Hooklet shutdownHooklet;
    private volatile ComponentState componentState;
    private final ReentrantLock lock = new ReentrantLock();

    public AbstractComponentLifecycle() {
        this.componentState = ComponentState.NEW;
        ActiveComponents.add(this);
    }

    @Override
    public void reentrantStart() {
        this.reentrantStart(this.hasAutoClose(), this.getShutdownPriority());
    }

    @Override
    public void reentrantStart(boolean autoClose) {
        this.reentrantStart(autoClose, this.getShutdownPriority());
    }

    protected void lazyReentrantStart() {
        if (this.componentState.ordinal() >= ComponentState.RUNNING.ordinal()) {
            return;
        }
        this.lock.lock();
        try {
            if (this.componentState.ordinal() >= ComponentState.RUNNING.ordinal()) {
                return;
            }
            this.reentrantStart();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void lazyReentrantStop() {
        if (this.componentState.ordinal() >= ComponentState.TERMINATED.ordinal()) {
            return;
        }
        this.lock.lock();
        try {
            if (this.componentState.ordinal() >= ComponentState.TERMINATED.ordinal()) {
                return;
            }
            this.reentrantStop();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void reentrantStart(boolean autoClose, int shutdownPriority) {
        if (this.ensureStarting()) {
            return;
        }
        try {
            if (this != CommonManager.getInstance()) {
                CommonManager.getInstance().reentrantStart();
            }
            this.dependOnStart();
            this.startInternal(autoClose, shutdownPriority);
            this.componentState = ComponentState.RUNNING;
            LoggerHelper.infov("{0} - {1} - <{2}>3:Current Strat state:{3}", this.getClass().getSimpleName(), "reentrantStart", this.getName(), this.componentState.name());
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    private boolean ensureStarting() {
        if (this.componentState != ComponentState.NEW) {
            return true;
        }
        ComponentLock.getInstance().lock();
        try {
            LoggerHelper.infov("{0} - {1} - <{2}>1:Current Strat state:{3}", this.getClass().getSimpleName(), "reentrantStart", this.getName(), this.componentState.name());
            if (this.componentState != ComponentState.NEW) {
                boolean bl = true;
                return bl;
            }
            this.componentState = ComponentState.STARTING;
            LoggerHelper.infov("{0} - {1} - <{2}>2:Current Strat state:{3}", this.getClass().getSimpleName(), "reentrantStart", this.getName(), this.componentState.name());
        }
        finally {
            ComponentLock.getInstance().unlock();
        }
        return false;
    }

    @Override
    public void reentrantStop() {
        if (this.ensureClosing()) {
            return;
        }
        try {
            this.stop();
            this.destroy();
            this.componentState = ComponentState.TERMINATED;
            LoggerHelper.infov("{0} - {1} - <{2}>6:Current Strat state:{3}", this.getClass().getSimpleName(), "reentrantStop", this.getName(), this.componentState.name());
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    private boolean ensureClosing() {
        if (this.componentState.ordinal() > ComponentState.RUNNING.ordinal()) {
            return true;
        }
        ComponentLock.getInstance().lock();
        try {
            LoggerHelper.infov("{0} - {1} - <{2}>4:Current Strat state:{3}", this.getClass().getSimpleName(), "reentrantStop", this.getName(), this.componentState.name());
            if (this.componentState.ordinal() > ComponentState.RUNNING.ordinal()) {
                boolean bl = true;
                return bl;
            }
            this.componentState = ComponentState.CLOSING;
            LoggerHelper.infov("{0} - {1} - <{2}>5:Current Stop state:{3}", this.getClass().getSimpleName(), "reentrantStop", this.getName(), this.componentState.name());
        }
        finally {
            ComponentLock.getInstance().unlock();
        }
        return false;
    }

    @Override
    public boolean isAlive() {
        ComponentLock.getInstance().readLock();
        try {
            boolean bl = this.componentState == ComponentState.RUNNING;
            return bl;
        }
        finally {
            ComponentLock.getInstance().readUnlock();
        }
    }

    @Override
    public void reentrantStopAndRemoveHooklet() {
        ActiveComponents.remove(this);
        this.reentrantStop();
        if (this.shutdownHooklet != null) {
            ExtPriorityHook.getInstance().remove(this.shutdownHooklet);
        }
    }

    @Override
    public ComponentState getState() {
        return this.componentState;
    }

    private void startInternal(boolean autoClose, int shutdownPriority) {
        this.initialize();
        this.start();
        if (autoClose) {
            this.shutdownHooklet = this.createHooklet(Math.max(shutdownPriority, this.getShutdownPriority()), this);
            ExtPriorityHook.getInstance().addAndGet(this.shutdownHooklet);
        }
    }

    @Override
    public int getShutdownPriority() {
        return ComponentShutdownPriority.LIB_LOWER.getValue();
    }

    protected boolean hasAutoClose() {
        return true;
    }

    protected Duration getShutdownAwait() {
        return CommonOptionResolver.getInstance().getAwaitTerminatedTimeout();
    }

    protected void dependOnStart() {
    }

    protected Hooklet createHooklet(final int priority, final ComponentLifecycle lifecycle) {
        return new Hooklet(){

            @Override
            public void onShutdown() {
                lifecycle.reentrantStop();
            }

            @Override
            public int priority() {
                return priority;
            }

            @Override
            protected Object identity() {
                return lifecycle.getClass();
            }
        };
    }

    private void error(Exception e) {
        LoggerHelper.warnv((Throwable)e, "error", new Object[0]);
        this.componentState = ComponentState.ERROR;
    }
}

