/*
 * Decompiled with CFR 0.152.
 */
package com.github.lontime.base.commonj.components;

import com.github.lontime.base.commonj.components.Lifecycle;
import com.github.lontime.base.commonj.config.CommonOptionResolver;
import com.github.lontime.extagrona.LoggingErrorHandler;
import com.github.lontime.extnetty.NettyThreadFactory;
import com.github.lontime.shaded.org.agrona.ErrorHandler;
import com.github.lontime.shaded.org.agrona.concurrent.Agent;
import com.github.lontime.shaded.org.agrona.concurrent.AgentRunner;
import com.github.lontime.shaded.org.agrona.concurrent.IdleStrategy;
import com.github.lontime.shaded.org.agrona.concurrent.SleepingIdleStrategy;
import com.github.lontime.shaded.org.agrona.concurrent.status.AtomicCounter;
import java.time.Duration;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;

public abstract class AbstractAgentLifecycle
implements Agent,
Lifecycle {
    protected static final ThreadFactory DEFAULT = new NettyThreadFactory("lontime-agent-", 0, true);
    private AgentRunner runner;
    protected final Logger logger = Logger.getLogger(this.getClass());

    protected boolean beforeStart() {
        return true;
    }

    protected boolean beforeStop() {
        return true;
    }

    @Override
    public void start() {
        if (!this.beforeStart()) {
            return;
        }
        this.runner = new AgentRunner(this.getIdleStrategy(), this.getErrorHandler(), this.getAtomicCounter(), (Agent)this);
        this.getThreadFactory().newThread((Runnable)this.runner).start();
    }

    @Override
    public void stop() {
        if (this.runner == null) {
            return;
        }
        if (!this.beforeStop()) {
            return;
        }
        this.runner.close((int)this.closeTimeout().toMillis(), this::closeFailAction);
    }

    @Override
    public boolean isAlive() {
        if (this.runner == null) {
            return false;
        }
        return !this.runner.isClosed();
    }

    public String roleName() {
        return this.getClass().getSimpleName();
    }

    protected Thread.State threadState() {
        if (this.runner == null) {
            return null;
        }
        return this.runner.thread().getState();
    }

    protected Duration closeTimeout() {
        return CommonOptionResolver.getInstance().getAwaitTerminatedTimeout();
    }

    protected IdleStrategy getIdleStrategy() {
        return new SleepingIdleStrategy(TimeUnit.SECONDS.toNanos(2L));
    }

    protected ErrorHandler getErrorHandler() {
        return new LoggingErrorHandler();
    }

    protected ThreadFactory getThreadFactory() {
        return DEFAULT;
    }

    protected AtomicCounter getAtomicCounter() {
        return null;
    }

    protected void closeFailAction(Thread thread) {
    }
}

