/*
 * Decompiled with CFR 0.152.
 */
package ljbo82.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Random;
import java.util.regex.Pattern;

public class StringUtils {
    private static StringUtils singleton;

    public static synchronized StringUtils getInstance() {
        if (singleton == null) {
            singleton = new StringUtils();
        }
        return singleton;
    }

    protected StringUtils() {
    }

    public final String getRandomString(int length) {
        char[] chars = "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
        return this.getRandomString(length, chars);
    }

    public String getRandomString(int length, char[] chars) {
        if (length < 1) {
            throw new IllegalArgumentException("Invalid length: " + length);
        }
        if (chars == null || chars.length == 0) {
            throw new IllegalArgumentException("Null/Empty chars");
        }
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            char c = chars[random.nextInt(chars.length)];
            sb.append(c);
        }
        return sb.toString();
    }

    public String getHexString(byte[] data) {
        StringBuilder builder = new StringBuilder();
        for (byte b : data) {
            builder.append(String.format("%02x", b));
        }
        return builder.toString();
    }

    public String replaceAll(String str, String what, String by, boolean recursive) {
        do {
            str = str.replaceAll(Pattern.quote(what), by);
        } while (recursive && str.contains(what) && !what.equals(by));
        return str;
    }

    public String read(InputStream is, boolean trimLines) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            String line;
            while ((line = br.readLine()) != null) {
                if (trimLines) {
                    line = line.trim();
                }
                sb.append(line).append("\n");
            }
        }
        String str = sb.toString();
        return str.isEmpty() ? str : str.substring(0, str.length() - 1);
    }

    public final String readInputStream(InputStream is) throws IOException {
        return this.read(is, false);
    }
}

