/*
 * Decompiled with CFR 0.152.
 */
package ljbo82.util;

import java.util.LinkedHashSet;
import java.util.Set;
import ljbo82.util.DependencyGraph;
import ljbo82.util.Path;
import ljbo82.util.Platform;

public class LibraryBundle {
    private final StringDependencyGraph libDependencyGraph = new StringDependencyGraph();
    private final Set<String> loadedLibs = new LinkedHashSet<String>();
    private final Platform platform = Platform.getInstance();

    protected Path[] getLibrarySearchDirs() {
        return this.platform.getLibrarySearchDirs();
    }

    protected String getLibraryPrefix() {
        return this.platform.getLibPrefix();
    }

    protected String getLibrarySuffix() {
        return this.platform.getLibSuffix();
    }

    public void registerLibrary(String libname, String ... dependencies) {
        this.libDependencyGraph.registerElement(libname, dependencies);
    }

    protected Path getLibraryFile(String libname) throws Path.PathAccessException {
        String libFilename = String.format("%s%s%s", this.getLibraryPrefix(), libname, this.getLibrarySuffix());
        for (Path libPath : this.getLibrarySearchDirs()) {
            Path libFile = new Path(libPath, libFilename);
            if (!libFile.exists()) continue;
            return libFile;
        }
        throw new Path.PathAccessException("Could not find a file associated with library: %s", libname);
    }

    public boolean isLoaded(String libname) {
        return this.loadedLibs.contains(libname);
    }

    protected void loadLibrary(String libname) throws UnsatisfiedLinkError {
        try {
            String path = this.getLibraryFile(libname).getAbsolutePath();
            try {
                System.load(path);
                this.loadedLibs.add(libname);
            }
            catch (UnsatisfiedLinkError ex) {
                throw new UnsatisfiedLinkError(String.format("Error loading library %s (%s): %s", libname, path, ex.getMessage()));
            }
        }
        catch (Path.PathAccessException ex) {
            throw new UnsatisfiedLinkError(ex.getMessage());
        }
    }

    private void _loadLibrary(String libname) throws UnsatisfiedLinkError {
        if (!this.isLoaded(libname)) {
            this.loadLibrary(libname);
        }
    }

    public void loadLibraries() throws UnsatisfiedLinkError {
        for (String libName : this.libDependencyGraph.getElements()) {
            for (String dep : this.libDependencyGraph.getDependencies(libName)) {
                this._loadLibrary(dep);
            }
            this._loadLibrary(libName);
        }
    }

    private static class StringDependencyGraph
    extends DependencyGraph<String> {
        private StringDependencyGraph() {
        }

        @Override
        protected String convertElement(String srcElement) {
            if ((srcElement = srcElement.trim()).isEmpty()) {
                return null;
            }
            return srcElement;
        }
    }
}

