/*
 * Decompiled with CFR 0.152.
 */
package ljbo82.util;

import java.util.LinkedHashMap;
import java.util.Map;
import ljbo82.util.EmbeddedResource;
import ljbo82.util.LibraryBundle;
import ljbo82.util.Path;
import ljbo82.util.Platform;

public class EmbeddedLibraryBundle
extends LibraryBundle {
    private final Platform platform = Platform.getInstance();
    private final Map<String, Path> extractedLibs = new LinkedHashMap<String, Path>();

    @Override
    protected final Path[] getLibrarySearchDirs() {
        throw new UnsupportedOperationException("Method not applicable for embedded libraries");
    }

    protected Path getExtractionDir() {
        return this.platform.getTemporaryDir();
    }

    protected String getEmbeddedLibraryDir() {
        return "lib";
    }

    protected EmbeddedResource getEmbeddedLibrary(String libname) throws Path.PathAccessException {
        boolean root = this.getEmbeddedLibraryDir().trim().isEmpty();
        String path = String.format("/%s%s%s%s", this.getEmbeddedLibraryDir(), root ? this.getLibraryPrefix() : "/" + this.getLibraryPrefix(), libname, this.getLibrarySuffix());
        return new EmbeddedResource(path);
    }

    protected boolean isExtracted(String libname) {
        return this.extractedLibs.containsKey(libname);
    }

    @Override
    protected Path getLibraryFile(String libname) throws Path.PathAccessException {
        if (this.isExtracted(libname)) {
            return this.extractedLibs.get(libname);
        }
        EmbeddedResource resource = this.getEmbeddedLibrary(libname);
        Path f = resource.extract(this.getExtractionDir());
        this.extractedLibs.put(libname, f);
        return f;
    }
}

