/*
 * Decompiled with CFR 0.152.
 */
package ljbo82.util;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public class DependencyGraph<T> {
    private final Map<T, Collection<T>> dependencyMap = new LinkedHashMap<T, Collection<T>>();

    protected T convertElement(T srcElement) {
        return srcElement;
    }

    private T _convertElement(T srcElement) {
        if (srcElement == null) {
            return null;
        }
        return this.convertElement(srcElement);
    }

    public void registerElement(T element, T ... dependencies) {
        if ((element = this._convertElement(element)) == null) {
            throw new IllegalArgumentException("Missing element");
        }
        Collection<T> dependencyCollection = this.dependencyMap.get(element);
        if (dependencyCollection == null) {
            dependencyCollection = new LinkedHashSet<T>();
        }
        LinkedHashSet<T> tmpDependencySet = new LinkedHashSet<T>();
        int i = 0;
        for (T dependency : dependencies) {
            if ((dependency = this._convertElement(dependency)) == null) {
                throw new IllegalArgumentException("Missing dependency at index " + i);
            }
            if (tmpDependencySet.contains(dependency)) {
                throw new IllegalArgumentException(String.format("Duplicate dependency at index %d: %s", i, dependency));
            }
            tmpDependencySet.add(dependency);
            dependencyCollection.add(dependency);
            if (!this.dependencyMap.containsKey(dependency)) {
                this.dependencyMap.put(dependency, new LinkedHashSet());
            }
            ++i;
        }
        if (!this.dependencyMap.containsKey(element)) {
            this.dependencyMap.put(element, dependencyCollection);
        }
        this.getDependencies(null, true, element);
    }

    private Collection<T> getDependencies(Collection<T> dependencies, boolean checkCyclic, T element) {
        Collection<T> tmpDeps;
        if ((element = this._convertElement(element)) == null) {
            throw new IllegalArgumentException("Missing element");
        }
        if (dependencies == null) {
            dependencies = new LinkedHashSet<T>();
        }
        if ((tmpDeps = this.dependencyMap.get(element)) == null) {
            tmpDeps = new LinkedHashSet<T>();
        }
        if (tmpDeps.isEmpty()) {
            return tmpDeps;
        }
        for (T dependency : tmpDeps) {
            Collection<T> transientDeps = this.getDependencies(null, checkCyclic, dependency);
            if (checkCyclic && transientDeps.contains(dependency)) {
                throw new CyclicReferenceException("Cyclic reference for %s", dependency);
            }
            dependencies.addAll(transientDeps);
            dependencies.add(dependency);
        }
        return dependencies;
    }

    public Collection<T> getDependencies(T element) {
        return this.getDependencies(null, false, element);
    }

    public Collection<T> getElements() {
        return this.dependencyMap.keySet();
    }

    public static class CyclicReferenceException
    extends RuntimeException {
        public CyclicReferenceException(String msg, Object ... msgArgs) {
            super(msgArgs.length == 0 ? msg : String.format(msg, msgArgs));
        }
    }
}

