/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuzhengyang.hotreload.boot;

import com.github.liuzhengyang.hotreload.boot.JavaVersionUtil;
import java.io.File;

public class JavaHomeUtil {
    private static volatile String FOUND_JAVA_HOME = null;

    public static String getJavaHomeDir() {
        if (FOUND_JAVA_HOME != null) {
            return FOUND_JAVA_HOME;
        }
        String javaHome = System.getProperty("java.home");
        if (JavaVersionUtil.isLessThanJava9()) {
            File toolsJar = new File(javaHome, "lib/tools.jar");
            if (!toolsJar.exists()) {
                toolsJar = new File(javaHome, "../lib/tools.jar");
            }
            if (!toolsJar.exists()) {
                toolsJar = new File("../../lib/tools.jar");
            }
            if (!toolsJar.exists()) {
                throw new IllegalArgumentException("Can not find tools.jar under java home");
            }
            FOUND_JAVA_HOME = javaHome;
        } else {
            FOUND_JAVA_HOME = javaHome;
        }
        return FOUND_JAVA_HOME;
    }

    public static File getToolsJar() {
        if (!JavaVersionUtil.isLessThanJava9()) {
            return null;
        }
        String javaHomeDir = JavaHomeUtil.getJavaHomeDir();
        File toolsJar = new File(javaHomeDir, "lib/tools.jar");
        if (!toolsJar.exists()) {
            toolsJar = new File(javaHomeDir, "../lib/tools.jar");
        }
        if (!toolsJar.exists()) {
            toolsJar = new File("../../lib/tools.jar");
        }
        if (!toolsJar.exists()) {
            throw new IllegalArgumentException("Can not find tools.jar under java.home");
        }
        return toolsJar;
    }
}

