/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuhuagui.spring.boot.autoconfigure;

import com.github.liuhuagui.smalldoc.core.SmallDocContext;
import com.github.liuhuagui.smalldoc.properties.SmallDocProperties;
import com.github.liuhuagui.smalldoc.web.SmallDocServlet;
import javax.servlet.Servlet;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Profile(value={"dev"})
@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={SmallDocContext.class})
@ConditionalOnProperty(name={"smalldoc.enabled"}, havingValue="true", matchIfMissing=true)
public class SmallDocAutoConfiguration {
    @Bean
    @ConfigurationProperties(value="smalldoc")
    public SmallDocProperties smallDocProperties() {
        return new SmallDocProperties();
    }

    @Bean
    public ServletRegistrationBean smallDocServletRegistrationBean(SmallDocProperties smallDocProperties) {
        ServletRegistrationBean registrationBean = new ServletRegistrationBean();
        registrationBean.setServlet((Servlet)new SmallDocServlet(smallDocProperties));
        registrationBean.addUrlMappings(new String[]{smallDocProperties.getUrlPattern() != null ? smallDocProperties.getUrlPattern() : "/smalldoc/*"});
        return registrationBean;
    }
}

