/*
 * Decompiled with CFR 0.152.
 */
package com.boot.auth.starter.utils;

import com.boot.auth.starter.utils.HexConver;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class AESUtil {
    private static final Logger log = LoggerFactory.getLogger(AESUtil.class);
    private static final String ALGORITHM = "AES";
    private static final String CHARSET_NAME = "UTF-8";

    private static void fixKeyLength() {
        int newMaxKeyLength;
        String errorString = "Failed manually overriding key-length permissions.";
        try {
            newMaxKeyLength = Cipher.getMaxAllowedKeyLength(ALGORITHM);
            if (newMaxKeyLength < 256) {
                Class<?> c = Class.forName("javax.crypto.CryptoAllPermissionCollection");
                Constructor<?> con = c.getDeclaredConstructor(new Class[0]);
                con.setAccessible(true);
                Object allPermissionCollection = con.newInstance(new Object[0]);
                Field f = c.getDeclaredField("all_allowed");
                f.setAccessible(true);
                f.setBoolean(allPermissionCollection, true);
                c = Class.forName("javax.crypto.CryptoPermissions");
                con = c.getDeclaredConstructor(new Class[0]);
                con.setAccessible(true);
                Object allPermissions = con.newInstance(new Object[0]);
                f = c.getDeclaredField("perms");
                f.setAccessible(true);
                ((Map)f.get(allPermissions)).put("*", allPermissionCollection);
                c = Class.forName("javax.crypto.JceSecurityManager");
                f = c.getDeclaredField("defaultPolicy");
                f.setAccessible(true);
                Field mf = Field.class.getDeclaredField("modifiers");
                mf.setAccessible(true);
                mf.setInt(f, f.getModifiers() & 0xFFFFFFEF);
                f.set(null, allPermissions);
                newMaxKeyLength = Cipher.getMaxAllowedKeyLength(ALGORITHM);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(errorString, e);
        }
        if (newMaxKeyLength < 256) {
            throw new RuntimeException(errorString);
        }
    }

    public static String encrypt(String content, String aesKey) {
        try {
            if (StringUtils.isEmpty((Object)content) || StringUtils.isEmpty((Object)aesKey)) {
                log.error("\u52a0\u5bc6\u6570\u636e\u5f02\u5e38,\u5185\u5bb9\u6216\u79c1\u94a5\u4e3a\u7a7a[content:{};aesKey:{}]", (Object)content, (Object)aesKey);
                return null;
            }
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            byte[] byteContent = content.getBytes(CHARSET_NAME);
            cipher.init(1, AESUtil.getSecretKey(aesKey));
            byte[] encryptResult = cipher.doFinal(byteContent);
            return HexConver.conver16HexStr(encryptResult);
        }
        catch (Exception e) {
            log.error("AES\u52a0\u5bc6\u6570\u636e\u5f02\u5e38\uff1a[content:{};aesKey:{}]", new Object[]{content, aesKey, e});
            return null;
        }
    }

    public static String decrypt(String content, String aesKey) {
        try {
            if (StringUtils.isEmpty((Object)content) || StringUtils.isEmpty((Object)aesKey)) {
                log.error("\u89e3\u5bc6\u6570\u636e\u5f02\u5e38,\u5185\u5bb9\u6216\u79c1\u94a5\u4e3a\u7a7a[content:{};aesKey:{}]", (Object)content, (Object)aesKey);
                return null;
            }
            byte[] contentByte = HexConver.conver16HexToByte(content);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, AESUtil.getSecretKey(aesKey));
            byte[] result = cipher.doFinal(contentByte);
            return new String(result, CHARSET_NAME);
        }
        catch (Exception e) {
            log.error("AES\u89e3\u5bc6\u6570\u636e\u5f02\u5e38\uff1a[content:{}; aesKey:{}]", (Object)content, (Object)aesKey);
            return null;
        }
    }

    private static SecretKeySpec getSecretKey(String aesKey) {
        KeyGenerator keyGenerator = null;
        try {
            keyGenerator = KeyGenerator.getInstance(ALGORITHM);
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.setSeed(aesKey.getBytes());
            keyGenerator.init(256, random);
            SecretKey secretKey = keyGenerator.generateKey();
            return new SecretKeySpec(secretKey.getEncoded(), ALGORITHM);
        }
        catch (NoSuchAlgorithmException ex) {
            log.error("\u83b7\u53d6\u52a0\u5bc6\u79d8\u94a5\u5f02\u5e38\uff1a[aesKey:{}]", (Object)aesKey);
            return null;
        }
    }

    static {
        Security.setProperty("crypto.policy", "unlimited");
        AESUtil.fixKeyLength();
    }
}

