/*
 * Decompiled with CFR 0.152.
 */
package com.boot.auth.starter.service.impl;

import com.boot.auth.starter.common.AuthProperties;
import com.boot.auth.starter.common.RestStatus;
import com.boot.auth.starter.exception.AuthException;
import com.boot.auth.starter.service.AuthService;
import com.boot.auth.starter.utils.AESUtil;
import com.boot.auth.starter.utils.CookieUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class AuthServiceImpl
implements AuthService {
    private static final Logger log = LoggerFactory.getLogger(AuthServiceImpl.class);
    @Autowired
    StringRedisTemplate redisTemplate;
    @Autowired
    ObjectMapper objectMapper;
    @Autowired
    AuthProperties authProperties;
    static final String TOKEN_NAME = "x-token".toLowerCase();

    @Override
    public String auth(String group, String userNo, String roles, Map<String, Object> parameters, HttpServletResponse response, HttpServletRequest request) throws Exception {
        Map<String, String> oldTokenMap = this.analysisToken(request);
        this.delToken(oldTokenMap);
        String key = userNo + "," + group;
        String token = AESUtil.encrypt(key + "," + System.currentTimeMillis(), this.authProperties.getDomain());
        if (parameters == null) {
            parameters = new HashMap<String, Object>();
        }
        parameters.put("userNo", userNo);
        parameters.put("roles", roles);
        this.redisTemplate.opsForValue().set((Object)(this.authProperties.getTokenPrefix() + key), (Object)this.objectMapper.writeValueAsString(parameters), this.authProperties.getOverdueTime().longValue(), TimeUnit.DAYS);
        CookieUtils.setCookie(request, response, TOKEN_NAME, token);
        response.setHeader(TOKEN_NAME, token);
        return token;
    }

    private void delToken(Map<String, String> oldTokenMap) {
        if (oldTokenMap.isEmpty() || !oldTokenMap.containsKey("key")) {
            return;
        }
        this.redisTemplate.delete((Object)(this.authProperties.getTokenPrefix() + oldTokenMap.get("key")));
    }

    @Override
    public Map<String, String> analysisToken(HttpServletRequest request) {
        String token = request.getHeader(TOKEN_NAME);
        if (StringUtils.isEmpty((Object)token)) {
            token = CookieUtils.getCookieValue(request, TOKEN_NAME);
        }
        return this.analysisToken(token);
    }

    @Override
    public Map<String, String> analysisToken(String token) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isEmpty((Object)token)) {
            return map;
        }
        try {
            String decryptToken = AESUtil.decrypt(token, this.authProperties.getDomain());
            assert (decryptToken != null);
            String[] keys = decryptToken.split(",");
            map.put("token", token);
            map.put("userNo", keys[0]);
            map.put("group", keys[1]);
            map.put("time", keys[2]);
            map.put("key", keys[0] + "," + keys[1]);
        }
        catch (Exception e) {
            log.error("\u89e3\u5bc6token\u5931\u8d25", (Throwable)e);
        }
        return map;
    }

    @Override
    public void deleteAuth(HttpServletRequest request) {
        this.delToken(this.analysisToken(request));
    }

    @Override
    public Boolean checkToken(HttpServletRequest request) {
        Map<String, String> tokenMap = this.analysisToken(request);
        if (tokenMap.isEmpty() || !tokenMap.containsKey("key")) {
            return false;
        }
        try {
            Long expire = this.redisTemplate.getExpire((Object)(this.authProperties.getTokenPrefix() + tokenMap.get("key")), TimeUnit.SECONDS);
            if (expire <= 0L) {
                return false;
            }
        }
        catch (Exception e) {
            throw new AuthException(RestStatus.SYSTEM_ERROR);
        }
        return true;
    }
}

