/*
 * Decompiled with CFR 0.152.
 */
package com.boot.auth.starter;

import com.boot.auth.starter.common.LogicSession;
import com.boot.auth.starter.common.RestStatus;
import com.boot.auth.starter.common.Session;
import com.boot.auth.starter.exception.AuthException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.springframework.data.redis.core.StringRedisTemplate;

public class SessionResolver {
    private final StringRedisTemplate redisTemplate;
    private final ObjectMapper objectMapper;
    private final String tokenPrefix;

    public SessionResolver(StringRedisTemplate redisTemplate, ObjectMapper objectMapper, String tokenPrefix) {
        this.redisTemplate = redisTemplate;
        this.objectMapper = objectMapper;
        this.tokenPrefix = tokenPrefix;
    }

    LogicSession resolve(Map<String, String> tokenMap, String platform, String version, String ip) {
        LogicSession logicSession = new LogicSession();
        if (tokenMap.isEmpty() || !tokenMap.containsKey("key")) {
            return logicSession;
        }
        String user = (String)this.redisTemplate.opsForValue().get((Object)(this.tokenPrefix + tokenMap.get("key")));
        if (user == null || user.trim().isEmpty()) {
            return logicSession;
        }
        try {
            JsonNode node = this.objectMapper.readTree(user);
            String nickName = node.path("nickName").asText();
            String openId = node.path("openId").asText();
            String unionId = node.path("unionId").asText();
            String userNo = node.path("userNo").asText();
            String avatar = node.path("avatar").asText();
            String roles = node.path("roles").asText();
            String mobile = node.path("mobile").asText();
            String obj = node.path("obj").asText();
            Session session = new Session();
            session.setUsername(nickName);
            session.setUnionId(unionId);
            session.setOpenId(openId);
            session.setUserNo(userNo);
            session.setAvatar(avatar);
            session.setRoles(roles);
            session.setMobile(mobile);
            session.setPlatform(platform);
            session.setVersion(version);
            session.setObj(obj);
            session.setIp(ip);
            logicSession.setValidLogin(true);
            logicSession.setValidToken(true);
            logicSession.setSessionOptional(Optional.of(session));
            return logicSession;
        }
        catch (IOException e) {
            throw new AuthException(RestStatus.SYSTEM_ERROR);
        }
    }
}

