/*
 * Decompiled with CFR 0.152.
 */
package com.boot.auth.starter;

import com.boot.auth.starter.AuthInterceptor;
import com.boot.auth.starter.SessionArgumentResolver;
import com.boot.auth.starter.SessionResolver;
import com.boot.auth.starter.common.AuthProperties;
import com.boot.auth.starter.common.RestStatus;
import com.boot.auth.starter.service.AuthService;
import com.boot.auth.starter.service.LogService;
import com.boot.auth.starter.service.OutJsonService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class AuthWebConfig
implements WebMvcConfigurer {
    @Autowired
    StringRedisTemplate redisTemplate;
    @Autowired
    ObjectMapper objectMapper;
    @Autowired
    AuthProperties authProperties;
    @Autowired
    AuthService authService;
    @Autowired
    LogService logService;
    @Autowired
    OutJsonService outJsonService;

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add(new SessionArgumentResolver());
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.authInterceptor());
    }

    @Bean
    public AuthInterceptor authInterceptor() {
        return new AuthInterceptor(this.sessionResolver(), this.loginRequired(), this.tokenInvalid(), this.authNoInvalid(), this.authService, this.logService);
    }

    @Bean
    SessionResolver sessionResolver() {
        return new SessionResolver(this.redisTemplate, this.objectMapper, this.authProperties.getTokenPrefix());
    }

    @Bean
    String loginRequired() {
        return this.outJsonService.errorOutJson(RestStatus.USER_NOLOGIIN.getMsg(), String.valueOf(RestStatus.USER_NOLOGIIN.value()));
    }

    @Bean
    String tokenInvalid() {
        return this.outJsonService.errorOutJson(RestStatus.USER_TOKEN_INVALID.getMsg(), String.valueOf(RestStatus.USER_TOKEN_INVALID.value()));
    }

    @Bean
    String authNoInvalid() {
        return this.outJsonService.errorOutJson(RestStatus.AUTH_NO.getMsg(), String.valueOf(RestStatus.AUTH_NO.value()));
    }
}

