/*
 * Decompiled with CFR 0.152.
 */
package com.boot.auth.starter;

import com.boot.auth.starter.SessionResolver;
import com.boot.auth.starter.annotation.Auth;
import com.boot.auth.starter.annotation.IgnoreLogin;
import com.boot.auth.starter.annotation.NoAuthGetSession;
import com.boot.auth.starter.annotation.OperLog;
import com.boot.auth.starter.common.LogicSession;
import com.boot.auth.starter.common.Session;
import com.boot.auth.starter.model.OperLogAnnotationEntity;
import com.boot.auth.starter.service.AuthService;
import com.boot.auth.starter.service.LogService;
import com.boot.auth.starter.utils.IPUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class AuthInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(AuthInterceptor.class);
    private final SessionResolver sessionResolver;
    private final String loginRequired;
    private final String tokenInvalid;
    private final String authNoInvalid;
    private final AuthService authService;
    private final LogService logService;

    public AuthInterceptor(SessionResolver sessionResolver, String loginRequired, String tokenInvalid, String authNoInvalid, AuthService authService, LogService logService) {
        this.sessionResolver = sessionResolver;
        this.loginRequired = loginRequired;
        this.tokenInvalid = tokenInvalid;
        this.authNoInvalid = authNoInvalid;
        this.authService = authService;
        this.logService = logService;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        LogicSession logicSession = this.getSession(request);
        Optional<Session> sessionOptional = logicSession.getSessionOptional();
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Auth auth = handlerMethod.getMethod().getDeclaringClass().getAnnotation(Auth.class);
        if (auth == null) {
            auth = (Auth)handlerMethod.getMethodAnnotation(Auth.class);
        }
        if (auth == null) {
            sessionOptional.ifPresent(s -> request.setAttribute("ATTR_SESSION", s));
            return true;
        }
        IgnoreLogin ignoreToken = handlerMethod.getMethod().getDeclaringClass().getAnnotation(IgnoreLogin.class);
        if (ignoreToken == null) {
            ignoreToken = (IgnoreLogin)handlerMethod.getMethodAnnotation(IgnoreLogin.class);
        }
        if (null != ignoreToken && ignoreToken.ignore()) {
            sessionOptional.ifPresent(s -> request.setAttribute("ATTR_SESSION", s));
            return true;
        }
        NoAuthGetSession noAuthGetSession = handlerMethod.getMethod().getDeclaringClass().getAnnotation(NoAuthGetSession.class);
        if (noAuthGetSession == null) {
            noAuthGetSession = (NoAuthGetSession)handlerMethod.getMethodAnnotation(NoAuthGetSession.class);
        }
        if (noAuthGetSession != null) {
            if (noAuthGetSession.loginRequired()) {
                sessionOptional.ifPresent(s -> request.setAttribute("ATTR_SESSION", s));
            }
            return true;
        }
        if (!logicSession.getValidLogin().booleanValue()) {
            this.send(response, this.loginRequired);
            log.warn("\u7528\u6237\u672a\u767b\u5f55,\u62d2\u7edd\u8bbf\u95ee[" + request.getRequestURI() + "]");
            return false;
        }
        if (!logicSession.getValidToken().booleanValue()) {
            this.send(response, this.tokenInvalid);
            log.warn("\u7528\u6237token\u5931\u6548,\u62d2\u7edd\u8bbf\u95ee[" + request.getRequestURI() + "]");
            return false;
        }
        List<String> roles = Arrays.asList(sessionOptional.get().getRoles().split(","));
        Optional<String> optionalRole = Arrays.stream(auth.roles()).filter(roles::contains).findFirst();
        if (!optionalRole.isPresent()) {
            this.send(response, this.authNoInvalid);
            log.warn("\u7528\u6237\u4e0d\u5177\u5907\u8bbf\u95ee\u6743\u9650,\u62d2\u7edd\u8bbf\u95ee[" + request.getRequestURI() + "]");
            return false;
        }
        sessionOptional.ifPresent(s -> request.setAttribute("ATTR_SESSION", s));
        return true;
    }

    private void send(HttpServletResponse response, String json) throws Exception {
        response.setContentType("application/json");
        response.getWriter().write(json);
        response.getWriter().close();
    }

    private LogicSession getSession(HttpServletRequest request) {
        return this.sessionResolver.resolve(this.authService.analysisToken(request), this.getHeaderValue(request, "platform"), this.getHeaderValue(request, "version"), IPUtils.getClientIP(request));
    }

    private void saveOperLog(HttpServletRequest request, HttpServletResponse response, Object handler) {
        LogicSession logicSession = this.getSession(request);
        Optional<Session> sessionOptional = logicSession.getSessionOptional();
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            OperLog operLog = handlerMethod.getMethod().getDeclaringClass().getAnnotation(OperLog.class);
            if (operLog == null) {
                operLog = (OperLog)handlerMethod.getMethodAnnotation(OperLog.class);
            }
            if (operLog != null && operLog.flag()) {
                OperLogAnnotationEntity logEntity = new OperLogAnnotationEntity();
                logEntity.setOperType(operLog.operType());
                logEntity.setChannel(this.getHeaderValue(request, "channel"));
                logEntity.setDeviceId(this.getHeaderValue(request, "deviceId"));
                if (sessionOptional.isPresent()) {
                    Session session = sessionOptional.get();
                    logEntity.setUserNo(session.getUserNo());
                    logEntity.setUsername(session.getUsername());
                    logEntity.setRoles(session.getRoles());
                    logEntity.setObj(session.getObj());
                    logEntity.setVersion(session.getVersion());
                    logEntity.setPlatform(session.getPlatform());
                } else {
                    logEntity.setIp(IPUtils.getClientIP(request));
                    logEntity.setVersion(this.getHeaderValue(request, "version"));
                    logEntity.setPlatform(this.getHeaderValue(request, "platform"));
                }
                this.logService.addLog(logEntity);
            }
        }
    }

    private String getHeaderValue(HttpServletRequest request, String key) {
        String value = "";
        try {
            value = request.getHeader(key);
        }
        catch (Exception e) {
            log.warn("header key is null", (Throwable)e);
        }
        return value;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable Exception ex) throws Exception {
        this.saveOperLog(request, response, handler);
    }
}

