/*
 * Decompiled with CFR 0.152.
 */
package com.github.linyuzai.event.rabbitmq.subscriber;

import com.github.linyuzai.event.core.context.EventContext;
import com.github.linyuzai.event.rabbitmq.endpoint.RabbitEventEndpoint;
import com.github.linyuzai.event.rabbitmq.subscriber.AbstractRabbitEventSubscriber;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerEndpoint;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpoint;

public class QueueRabbitEventSubscriber
extends AbstractRabbitEventSubscriber {
    private final String[] queues;

    public QueueRabbitEventSubscriber(String ... queues) {
        this.queues = queues;
    }

    @Override
    public MessageListenerContainer createMessageListenerContainer(RabbitEventEndpoint endpoint, EventContext context, MessageListener messageListener) {
        SimpleRabbitListenerEndpoint listenerEndpoint = new SimpleRabbitListenerEndpoint();
        listenerEndpoint.setQueueNames(this.queues);
        listenerEndpoint.setAdmin((AmqpAdmin)endpoint.getAdmin());
        listenerEndpoint.setMessageListener(messageListener);
        return endpoint.getListenerContainerFactory().createListenerContainer((RabbitListenerEndpoint)listenerEndpoint);
    }

    public String[] getQueues() {
        return this.queues;
    }
}

