/*
 * Decompiled with CFR 0.152.
 */
package com.github.linyuzai.event.rabbitmq.publisher;

import com.github.linyuzai.event.core.context.EventContext;
import com.github.linyuzai.event.rabbitmq.endpoint.RabbitEventEndpoint;
import com.github.linyuzai.event.rabbitmq.publisher.AbstractRabbitEventPublisher;

public class RoutingRabbitEventPublisher
extends AbstractRabbitEventPublisher {
    private final String exchange;
    private final String routingKey;

    @Override
    public void send(Object event, RabbitEventEndpoint endpoint, EventContext context) {
        endpoint.getTemplate().convertAndSend(this.exchange, this.routingKey, event);
    }

    public String getExchange() {
        return this.exchange;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public RoutingRabbitEventPublisher(String exchange, String routingKey) {
        this.exchange = exchange;
        this.routingKey = routingKey;
    }
}

