/*
 * Decompiled with CFR 0.152.
 */
package com.github.linyuzai.event.rabbitmq.publisher;

import com.github.linyuzai.event.core.context.EventContext;
import com.github.linyuzai.event.rabbitmq.endpoint.RabbitEventEndpoint;
import com.github.linyuzai.event.rabbitmq.publisher.AbstractRabbitEventPublisher;
import java.util.function.Supplier;
import org.springframework.amqp.rabbit.connection.CorrelationData;

public class ConfigurableRabbitEventPublisher
extends AbstractRabbitEventPublisher {
    private Supplier<String> exchange = () -> null;
    private Supplier<String> routingKey = () -> null;
    private Supplier<CorrelationData> correlationData = () -> null;

    @Override
    public void send(Object event, RabbitEventEndpoint endpoint, EventContext context) {
        endpoint.getTemplate().convertAndSend(this.exchange.get(), this.routingKey.get(), event, this.correlationData.get());
    }

    public void setExchange(Supplier<String> exchange) {
        this.exchange = exchange;
    }

    public void setRoutingKey(Supplier<String> routingKey) {
        this.routingKey = routingKey;
    }

    public void setCorrelationData(Supplier<CorrelationData> correlationData) {
        this.correlationData = correlationData;
    }

    public Supplier<String> getExchange() {
        return this.exchange;
    }

    public Supplier<String> getRoutingKey() {
        return this.routingKey;
    }

    public Supplier<CorrelationData> getCorrelationData() {
        return this.correlationData;
    }
}

