/*
 * Decompiled with CFR 0.152.
 */
package com.github.linyuzai.event.rabbitmq.inherit;

import com.github.linyuzai.event.core.config.AbstractInheritHandler;
import com.github.linyuzai.event.rabbitmq.inherit.RabbitInheritHandler;
import com.github.linyuzai.event.rabbitmq.properties.RabbitEventProperties;
import java.lang.reflect.Field;
import java.time.Duration;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.core.env.Environment;

public class ReflectionRabbitInheritHandler
extends AbstractInheritHandler<RabbitEventProperties>
implements RabbitInheritHandler {
    private final Environment environment;

    public Class<?> getRootClass() {
        return RabbitProperties.class;
    }

    public String getRootPrefix() {
        return "concept.event.rabbitmq.endpoints";
    }

    public boolean needInherit(Field field) {
        String name = field.getName();
        return !name.equals("parsedAddresses") && !name.equals("host");
    }

    public boolean hasCustomValue(String key) {
        return this.environment.getProperty(key) != null;
    }

    public boolean isValueType(Class<?> clazz) {
        return super.isValueType(clazz) || clazz == Duration.class;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public ReflectionRabbitInheritHandler(Environment environment) {
        this.environment = environment;
    }
}

