/*
 * Decompiled with CFR 0.152.
 */
package com.github.linyuzai.event.rabbitmq.inherit;

import com.github.linyuzai.event.core.config.AbstractInheritHandler;
import com.github.linyuzai.event.core.config.PropertiesConfig;
import com.github.linyuzai.event.rabbitmq.exception.RabbitEventException;
import com.github.linyuzai.event.rabbitmq.inherit.RabbitInheritHandler;
import com.github.linyuzai.event.rabbitmq.properties.RabbitEventProperties;
import java.util.Map;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@Deprecated
public class RabbitInheritHandlerImpl
implements RabbitInheritHandler {
    private final Environment environment;

    public void inherit(RabbitEventProperties properties) {
        Map<String, RabbitEventProperties.ExtendedRabbitProperties> endpoints = properties.getEndpoints();
        for (Map.Entry<String, RabbitEventProperties.ExtendedRabbitProperties> entry : endpoints.entrySet()) {
            String name = entry.getKey();
            RabbitEventProperties.ExtendedRabbitProperties rabbitProperties = entry.getValue();
            if (!StringUtils.hasText((String)rabbitProperties.getInherit())) continue;
            RabbitEventProperties.ExtendedRabbitProperties inherit = endpoints.get(rabbitProperties.getInherit());
            if (inherit == null) {
                throw new RabbitEventException("Inherit not found: " + rabbitProperties.getInherit());
            }
            this.inherit(name, rabbitProperties, inherit);
        }
    }

    public void inherit(String name, RabbitEventProperties.ExtendedRabbitProperties child, RabbitEventProperties.ExtendedRabbitProperties parent) {
        String channelRpcTimeout;
        String publisherReturns;
        String requestedChannelMax;
        String addressShuffleMode;
        String password;
        String username;
        String prefix = "concept.event.rabbitmq.endpoints." + name;
        if (child.getPort() == null) {
            child.setPort(parent.getPort());
        }
        if ((username = this.environment.getProperty(prefix + ".username")) == null) {
            child.setUsername(parent.getUsername());
        }
        if ((password = this.environment.getProperty(prefix + ".password")) == null) {
            child.setPassword(parent.getPassword());
        }
        this.inheritSsl(child.getSsl(), parent.getSsl(), prefix + ".ssl");
        if (child.getVirtualHost() == null) {
            child.setVirtualHost(parent.getVirtualHost());
        }
        if (child.getAddresses() == null) {
            child.setAddresses(parent.getAddresses());
        }
        if ((addressShuffleMode = this.environment.getProperty(prefix + ".address-shuffle-mode")) == null) {
            child.setAddressShuffleMode(parent.getAddressShuffleMode());
        }
        if (child.getRequestedHeartbeat() == null) {
            child.setRequestedHeartbeat(parent.getRequestedHeartbeat());
        }
        if ((requestedChannelMax = this.environment.getProperty(prefix + ".requested-channel-max")) == null) {
            child.setRequestedChannelMax(parent.getRequestedChannelMax());
        }
        if ((publisherReturns = this.environment.getProperty(prefix + ".publisher-returns")) == null) {
            child.setPublisherReturns(parent.isPublisherReturns());
        }
        if (child.getPublisherConfirmType() == null) {
            child.setPublisherConfirmType(parent.getPublisherConfirmType());
        }
        if (child.getConnectionTimeout() == null) {
            child.setConnectionTimeout(parent.getConnectionTimeout());
        }
        if ((channelRpcTimeout = this.environment.getProperty(prefix + ".channel-rpc-timeout")) == null) {
            child.setChannelRpcTimeout(parent.getChannelRpcTimeout());
        }
        this.inheritCache(child.getCache(), parent.getCache(), prefix + "cache");
        this.inheritListener(child.getListener(), parent.getListener(), prefix + ".listener");
        this.inheritTemplate(child.getTemplate(), parent.getTemplate(), prefix + ".template");
        this.inheritStream(child.getStream(), parent.getStream(), prefix + ".stream");
        this.inheritExtended((PropertiesConfig)child, (PropertiesConfig)parent);
    }

    public void inheritSsl(RabbitProperties.Ssl child, RabbitProperties.Ssl parent, String prefix) {
        String verifyHostname;
        String validateServerCertificate;
        String trustStoreAlgorithm;
        String trustStoreType;
        String keyStoreAlgorithm;
        String keyStoreType;
        if (child.getEnabled() == null) {
            child.setEnabled(parent.getEnabled());
        }
        if (child.getKeyStore() == null) {
            child.setKeyStore(parent.getKeyStore());
        }
        if ((keyStoreType = this.environment.getProperty(prefix + ".key-store-type")) == null) {
            child.setKeyStoreType(parent.getKeyStoreType());
        }
        if (child.getKeyStorePassword() == null) {
            child.setKeyStorePassword(parent.getKeyStorePassword());
        }
        if ((keyStoreAlgorithm = this.environment.getProperty(prefix + ".key-store-algorithm")) == null) {
            child.setKeyStoreAlgorithm(parent.getKeyStoreAlgorithm());
        }
        if (child.getTrustStore() == null) {
            child.setTrustStore(parent.getTrustStore());
        }
        if ((trustStoreType = this.environment.getProperty(prefix + ".trust-store-type")) == null) {
            child.setTrustStoreType(parent.getTrustStoreType());
        }
        if (child.getTrustStorePassword() == null) {
            child.setTrustStorePassword(parent.getTrustStorePassword());
        }
        if ((trustStoreAlgorithm = this.environment.getProperty(prefix + ".trust-store-algorithm")) == null) {
            child.setKeyStoreAlgorithm(parent.getKeyStoreAlgorithm());
        }
        if (child.getAlgorithm() == null) {
            child.setAlgorithm(parent.getAlgorithm());
        }
        if ((validateServerCertificate = this.environment.getProperty(prefix + ".validate-server-certificate")) == null) {
            child.setValidateServerCertificate(parent.isValidateServerCertificate());
        }
        if ((verifyHostname = this.environment.getProperty(prefix + ".verify-hostname")) == null) {
            child.setVerifyHostname(parent.getVerifyHostname());
        }
    }

    public void inheritCache(RabbitProperties.Cache child, RabbitProperties.Cache parent, String prefix) {
        this.inheritCacheChannel(child.getChannel(), parent.getChannel());
        this.inheritCacheConnection(child.getConnection(), parent.getConnection(), prefix + ".connection");
    }

    public void inheritCacheChannel(RabbitProperties.Cache.Channel child, RabbitProperties.Cache.Channel parent) {
        if (child.getSize() == null) {
            child.setSize(parent.getSize());
        }
        if (child.getCheckoutTimeout() == null) {
            child.setCheckoutTimeout(parent.getCheckoutTimeout());
        }
    }

    public void inheritCacheConnection(RabbitProperties.Cache.Connection child, RabbitProperties.Cache.Connection parent, String prefix) {
        String mode = this.environment.getProperty(prefix + ".mode");
        if (mode == null) {
            child.setMode(parent.getMode());
        }
        if (child.getSize() == null) {
            child.setSize(parent.getSize());
        }
    }

    public void inheritListener(RabbitProperties.Listener child, RabbitProperties.Listener parent, String prefix) {
        String type = this.environment.getProperty(prefix + ".type");
        if (type == null) {
            child.setType(parent.getType());
        }
        this.inheritSimpleContainer(child.getSimple(), parent.getSimple(), prefix + ".simple");
        this.inheritDirectContainer(child.getDirect(), parent.getDirect(), prefix + ".direct");
        this.inheritStreamContainer(child.getStream(), parent.getStream(), prefix + ".stream");
    }

    public void inheritSimpleContainer(RabbitProperties.SimpleContainer child, RabbitProperties.SimpleContainer parent, String prefix) {
        String consumerBatchEnabled;
        String missingQueuesFatal;
        this.inheritAmqpContainer((RabbitProperties.AmqpContainer)child, (RabbitProperties.AmqpContainer)parent, prefix);
        if (child.getConcurrency() == null) {
            child.setConcurrency(parent.getConcurrency());
        }
        if (child.getMaxConcurrency() == null) {
            child.setMaxConcurrency(parent.getMaxConcurrency());
        }
        if (child.getBatchSize() == null) {
            child.setBatchSize(parent.getBatchSize());
        }
        if ((missingQueuesFatal = this.environment.getProperty(prefix + ".missing-queues-fatal")) == null) {
            child.setMissingQueuesFatal(parent.isMissingQueuesFatal());
        }
        if ((consumerBatchEnabled = this.environment.getProperty(prefix + ".consumer-batch-enabled")) == null) {
            child.setConsumerBatchEnabled(parent.isConsumerBatchEnabled());
        }
    }

    public void inheritDirectContainer(RabbitProperties.DirectContainer child, RabbitProperties.DirectContainer parent, String prefix) {
        String missingQueuesFatal;
        this.inheritAmqpContainer((RabbitProperties.AmqpContainer)child, (RabbitProperties.AmqpContainer)parent, prefix);
        if (child.getConsumersPerQueue() == null) {
            child.setConsumersPerQueue(parent.getConsumersPerQueue());
        }
        if ((missingQueuesFatal = this.environment.getProperty(prefix + ".missing-queues-fatal")) == null) {
            child.setMissingQueuesFatal(parent.isMissingQueuesFatal());
        }
    }

    public void inheritStreamContainer(RabbitProperties.StreamContainer child, RabbitProperties.StreamContainer parent, String prefix) {
        this.inheritBaseContainer((RabbitProperties.BaseContainer)child, (RabbitProperties.BaseContainer)parent, prefix);
        String nativeListener = this.environment.getProperty(prefix + ".native-listener");
        if (nativeListener == null) {
            child.setNativeListener(parent.isNativeListener());
        }
    }

    public void inheritAmqpContainer(RabbitProperties.AmqpContainer child, RabbitProperties.AmqpContainer parent, String prefix) {
        String deBatchingEnabled;
        this.inheritBaseContainer((RabbitProperties.BaseContainer)child, (RabbitProperties.BaseContainer)parent, prefix);
        if (child.getAcknowledgeMode() == null) {
            child.setAcknowledgeMode(parent.getAcknowledgeMode());
        }
        if (child.getPrefetch() == null) {
            child.setPrefetch(parent.getPrefetch());
        }
        if (child.getDefaultRequeueRejected() == null) {
            child.setDefaultRequeueRejected(parent.getDefaultRequeueRejected());
        }
        if (child.getIdleEventInterval() == null) {
            child.setIdleEventInterval(parent.getIdleEventInterval());
        }
        if ((deBatchingEnabled = this.environment.getProperty(prefix + ".de-batching-enabled")) == null) {
            child.setDeBatchingEnabled(parent.isDeBatchingEnabled());
        }
        this.inheritListenerRetry(child.getRetry(), parent.getRetry(), prefix + ".retry");
    }

    public void inheritListenerRetry(RabbitProperties.ListenerRetry child, RabbitProperties.ListenerRetry parent, String prefix) {
        this.inheritRetry((RabbitProperties.Retry)child, (RabbitProperties.Retry)parent, prefix);
        String stateless = this.environment.getProperty(prefix + ".stateless");
        if (stateless == null) {
            child.setStateless(parent.isStateless());
        }
    }

    public void inheritBaseContainer(RabbitProperties.BaseContainer child, RabbitProperties.BaseContainer parent, String prefix) {
        String autoStartup = this.environment.getProperty(prefix + ".auto-startup");
        if (autoStartup == null) {
            child.setAutoStartup(parent.isAutoStartup());
        }
    }

    public void inheritTemplate(RabbitProperties.Template child, RabbitProperties.Template parent, String prefix) {
        String routingKey;
        String exchange;
        this.inheritRetry(child.getRetry(), parent.getRetry(), prefix + ".retry");
        if (child.getMandatory() == null) {
            child.setMandatory(parent.getMandatory());
        }
        if (child.getReceiveTimeout() == null) {
            child.setReceiveTimeout(parent.getReceiveTimeout());
        }
        if (child.getReplyTimeout() == null) {
            child.setReplyTimeout(parent.getReplyTimeout());
        }
        if ((exchange = this.environment.getProperty(prefix + ".exchange")) == null) {
            child.setExchange(parent.getExchange());
        }
        if ((routingKey = this.environment.getProperty(prefix + ".routing-key")) == null) {
            child.setRoutingKey(parent.getRoutingKey());
        }
        if (child.getDefaultReceiveQueue() == null) {
            child.setDefaultReceiveQueue(parent.getDefaultReceiveQueue());
        }
    }

    public void inheritRetry(RabbitProperties.Retry child, RabbitProperties.Retry parent, String prefix) {
        String maxInterval;
        String multiplier;
        String initialInterval;
        String maxAttempts;
        String enabled = this.environment.getProperty(prefix + ".enabled");
        if (enabled == null) {
            child.setEnabled(parent.isEnabled());
        }
        if ((maxAttempts = this.environment.getProperty(prefix + ".max-attempts")) == null) {
            child.setMaxAttempts(parent.getMaxAttempts());
        }
        if ((initialInterval = this.environment.getProperty(prefix + ".initial-interval")) == null) {
            child.setInitialInterval(parent.getInitialInterval());
        }
        if ((multiplier = this.environment.getProperty(prefix + ".multiplier")) == null) {
            child.setMultiplier(parent.getMultiplier());
        }
        if ((maxInterval = this.environment.getProperty(prefix + ".max-interval")) == null) {
            child.setMaxInterval(parent.getMaxInterval());
        }
    }

    public void inheritStream(RabbitProperties.Stream child, RabbitProperties.Stream parent, String prefix) {
        String port = this.environment.getProperty(".port");
        if (port == null) {
            child.setPort(parent.getPort());
        }
        if (child.getUsername() == null) {
            child.setUsername(parent.getUsername());
        }
        if (child.getPassword() == null) {
            child.setPassword(parent.getPassword());
        }
    }

    public void inheritExtended(PropertiesConfig child, PropertiesConfig parent) {
        AbstractInheritHandler.inherit((PropertiesConfig)child, (PropertiesConfig)parent);
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public RabbitInheritHandlerImpl(Environment environment) {
        this.environment = environment;
    }
}

