/*
 * Decompiled with CFR 0.152.
 */
package com.github.linyuzai.event.rabbitmq.endpoint;

import com.github.linyuzai.event.core.context.EventContext;
import com.github.linyuzai.event.core.endpoint.AbstractEventEndpoint;
import com.github.linyuzai.event.core.endpoint.EventEndpoint;
import com.github.linyuzai.event.core.engine.EventEngine;
import com.github.linyuzai.event.core.listener.EventListener;
import com.github.linyuzai.event.core.subscriber.Subscription;
import com.github.linyuzai.event.rabbitmq.exception.RabbitEventException;
import com.github.linyuzai.event.rabbitmq.properties.RabbitEventProperties;
import com.github.linyuzai.event.rabbitmq.publisher.DefaultRabbitEventPublisher;
import lombok.NonNull;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.amqp.rabbit.listener.RabbitListenerContainerFactory;

public class RabbitEventEndpoint
extends AbstractEventEndpoint {
    private RabbitEventProperties.ExtendedRabbitProperties properties;
    private ConnectionFactory connectionFactory;
    private RabbitListenerContainerFactory<? extends MessageListenerContainer> listenerContainerFactory;
    private RabbitTemplate template;
    private RabbitAdmin admin;

    public RabbitEventEndpoint(@NonNull String name, @NonNull EventEngine engine) {
        super(name, engine);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (engine == null) {
            throw new NullPointerException("engine is marked non-null but is null");
        }
    }

    public void defaultPublish(Object event, EventContext context) {
        new DefaultRabbitEventPublisher().publish(event, (EventEndpoint)this, context);
    }

    public Subscription defaultSubscribe(EventListener listener, EventContext context) {
        throw new RabbitEventException("EventSubscriber is null");
    }

    public RabbitEventProperties.ExtendedRabbitProperties getProperties() {
        return this.properties;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public RabbitListenerContainerFactory<? extends MessageListenerContainer> getListenerContainerFactory() {
        return this.listenerContainerFactory;
    }

    public RabbitTemplate getTemplate() {
        return this.template;
    }

    public RabbitAdmin getAdmin() {
        return this.admin;
    }

    public void setProperties(RabbitEventProperties.ExtendedRabbitProperties properties) {
        this.properties = properties;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setListenerContainerFactory(RabbitListenerContainerFactory<? extends MessageListenerContainer> listenerContainerFactory) {
        this.listenerContainerFactory = listenerContainerFactory;
    }

    public void setTemplate(RabbitTemplate template) {
        this.template = template;
    }

    public void setAdmin(RabbitAdmin admin) {
        this.admin = admin;
    }
}

