package indi.mybatis.flying.statics;

import java.util.HashMap;
import java.util.Map;

/**
 * 
 * @date 2019年12月18日 11:56:08
 *
 * @author 李萌
 * @email limeng32@live.cn
 * @since JDK 1.8
 */
public enum KeyGeneratorType {
	/** Generate by UUID */
	UUID("uuid"),
	/** Generated by UUID without a horizontal line */
	UUID_NO_LINE("uuid_no_line"),
	/** Timestamp that is accurate to millisecond */
	MILLISECOND("millisecond"),
	/** The simple prototype of snowflake algorithm, for reference only */
	SNOWFLAKE("snowflake"),
	/** User personalization handler */
	CUSTOM("custom");

	private final String value;

	private KeyGeneratorType(String value) {
		this.value = value;
	}

	public String value() {
		return value;
	}

	private static final Map<String, KeyGeneratorType> mapForValue = new HashMap<>(8);

	static {
		KeyGeneratorType[] values = KeyGeneratorType.values();
		for (KeyGeneratorType e : values) {
			mapForValue.put(e.value(), e);
		}
	}

	public static KeyGeneratorType forValue(String value) {
		return mapForValue.get(value);
	}
}
