/*
 * Decompiled with CFR 0.152.
 */
package com.github.kuliginstepan.outbox.relational.autoconfigure;

import com.github.kuliginstepan.outbox.relational.autoconfigure.ExtendedRelationalOutboxProperties;
import io.r2dbc.spi.ConnectionFactory;
import java.util.List;
import org.springframework.boot.jdbc.init.PlatformPlaceholderDatabaseDriverResolver;
import org.springframework.boot.r2dbc.init.R2dbcScriptDatabaseInitializer;
import org.springframework.boot.sql.init.DatabaseInitializationSettings;
import org.springframework.util.StringUtils;

public class R2dbcOutboxScriptDatabaseInitializer
extends R2dbcScriptDatabaseInitializer {
    public R2dbcOutboxScriptDatabaseInitializer(ConnectionFactory connectionFactory, ExtendedRelationalOutboxProperties.RelationalOutboxProperties properties) {
        this(connectionFactory, R2dbcOutboxScriptDatabaseInitializer.getSettings(connectionFactory, properties));
    }

    public R2dbcOutboxScriptDatabaseInitializer(ConnectionFactory connectionFactory, DatabaseInitializationSettings settings) {
        super(connectionFactory, settings);
    }

    static DatabaseInitializationSettings getSettings(ConnectionFactory connectionFactory, ExtendedRelationalOutboxProperties.RelationalOutboxProperties properties) {
        DatabaseInitializationSettings settings = new DatabaseInitializationSettings();
        settings.setSchemaLocations(R2dbcOutboxScriptDatabaseInitializer.resolveSchemaLocations(connectionFactory, properties));
        settings.setMode(properties.getInitializeSchema());
        settings.setContinueOnError(true);
        return settings;
    }

    private static List<String> resolveSchemaLocations(ConnectionFactory connectionFactory, ExtendedRelationalOutboxProperties.RelationalOutboxProperties properties) {
        PlatformPlaceholderDatabaseDriverResolver platformResolver = new PlatformPlaceholderDatabaseDriverResolver();
        if (StringUtils.hasText((String)properties.getPlatform())) {
            return platformResolver.resolveAll(properties.getPlatform(), new String[]{properties.getSchema()});
        }
        return platformResolver.resolveAll(connectionFactory.getMetadata().getName().toLowerCase(), new String[]{properties.getSchema()});
    }
}

