/*
 * Decompiled with CFR 0.152.
 */
package com.github.kuliginstepan.outbox.relational.autoconfigure;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.kuliginstepan.outbox.core.OutboxEntity;
import com.github.kuliginstepan.outbox.core.OutboxMethodIdentifier;
import com.github.kuliginstepan.outbox.core.ReactiveOutboxRepository;
import com.github.kuliginstepan.outbox.relational.autoconfigure.ExtendedRelationalOutboxProperties;
import io.r2dbc.spi.Row;
import java.time.Instant;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.springframework.r2dbc.core.DatabaseClient;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class R2dbcOutboxRepository
implements ReactiveOutboxRepository {
    private static final String INSERT_QUERY = "INSERT INTO %TABLE_NAME% (ID, PUBLICATION_DATE, OUTBOX_METHOD_ID, DATA_TYPE, DATA) VALUES (:id, :publicationDate, :outboxMethodId, :dataType, :data)";
    private static final String MARK_COMPLETED_QUERY = "UPDATE %TABLE_NAME% SET COMPLETION_DATE=:completionDate WHERE ID=:id AND COMPLETION_DATE IS NULL";
    private static final String DELETE_COMPLETED_QUERY = "DELETE FROM %TABLE_NAME% WHERE COMPLETION_DATE IS NOT NULL AND PUBLICATION_DATE <= :publicationDate";
    private static final String SELECT_UNCOMPLETED_QUERY = "SELECT * FROM %TABLE_NAME% WHERE COMPLETION_DATE IS NULL AND PUBLICATION_DATE <= :publicationDate";
    private final DatabaseClient client;
    private final ObjectMapper mapper;
    private final String insertQuery;
    private final String markCompletedQuery;
    private final String deleteCompletedQuery;
    private final String selectUncompletedQuery;

    public R2dbcOutboxRepository(DatabaseClient client, ObjectMapper mapper, ExtendedRelationalOutboxProperties.RelationalOutboxProperties properties) {
        this.client = client;
        this.mapper = mapper;
        this.insertQuery = this.getQuery(INSERT_QUERY, properties.getTable());
        this.markCompletedQuery = this.getQuery(MARK_COMPLETED_QUERY, properties.getTable());
        this.deleteCompletedQuery = this.getQuery(DELETE_COMPLETED_QUERY, properties.getTable());
        this.selectUncompletedQuery = this.getQuery(SELECT_UNCOMPLETED_QUERY, properties.getTable());
    }

    public Mono<Void> save(OutboxEntity entity) {
        return this.client.sql(this.insertQuery).bind("id", (Object)entity.getId()).bind("outboxMethodId", (Object)entity.getMethodIdentifier().getValue()).bind("publicationDate", (Object)entity.getPublicationDate().toEpochMilli()).bind("data", (Object)this.serialize(entity.getData())).bind("dataType", (Object)Arrays.stream(entity.getData()).map(Object::getClass).map(ClassUtils::getQualifiedName).collect(Collectors.joining(","))).then();
    }

    public Mono<Void> markCompleted(OutboxEntity entity) {
        return this.client.sql(this.markCompletedQuery).bind("completionDate", (Object)Instant.now().toEpochMilli()).bind("id", (Object)entity.getId()).then();
    }

    public Mono<Void> deleteCompletedEntities(Instant notAfterDate) {
        return this.client.sql(this.deleteCompletedQuery).bind("publicationDate", (Object)notAfterDate.toEpochMilli()).then();
    }

    public Flux<OutboxEntity> findUncompletedEntities(Instant notAfterDate) {
        return this.client.sql(this.selectUncompletedQuery).bind("publicationDate", (Object)notAfterDate.toEpochMilli()).map(row -> new OutboxEntity(){
            final /* synthetic */ Row val$row;
            {
                this.val$row = row;
            }

            public String getId() {
                return (String)this.val$row.get("ID", String.class);
            }

            public Instant getPublicationDate() {
                return Instant.ofEpochMilli((Long)this.val$row.get("PUBLICATION_DATE", Long.class));
            }

            public OutboxMethodIdentifier getMethodIdentifier() {
                return OutboxMethodIdentifier.of((String)((String)this.val$row.get("OUTBOX_METHOD_ID", String.class)));
            }

            public Object[] getData() {
                Class[] dataTypes = (Class[])Arrays.stream(((String)this.val$row.get("DATA_TYPE", String.class)).split(",")).map(type -> ClassUtils.resolveClassName((String)type, null)).toArray(Class[]::new);
                Object[] objects = R2dbcOutboxRepository.this.deserialize((String)this.val$row.get("DATA", String.class), Object[].class);
                for (int i = 0; i < objects.length; ++i) {
                    objects[i] = R2dbcOutboxRepository.this.mapper.convertValue(objects[i], dataTypes[i]);
                }
                return objects;
            }
        }).all();
    }

    private String serialize(Object o) {
        try {
            return this.mapper.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T deserialize(String data, Class<T> type) {
        try {
            return (T)this.mapper.readValue(data, type);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private String getQuery(String base, String tableName) {
        return StringUtils.replace((String)base, (String)"%TABLE_NAME%", (String)tableName);
    }
}

