/*
 * Decompiled with CFR 0.152.
 */
package com.github.kuliginstepan.outbox.relational.autoconfigure;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.kuliginstepan.outbox.core.DefaultReactiveOutboxPersistenceManager;
import com.github.kuliginstepan.outbox.core.DefaultReactiveOutboxRepublisher;
import com.github.kuliginstepan.outbox.core.OutboxEntityFactory;
import com.github.kuliginstepan.outbox.core.ReactiveOutboxAspect;
import com.github.kuliginstepan.outbox.core.ReactiveOutboxPersistenceManager;
import com.github.kuliginstepan.outbox.core.ReactiveOutboxRepository;
import com.github.kuliginstepan.outbox.core.ReactiveOutboxRepublisher;
import com.github.kuliginstepan.outbox.core.ReactiveRepublisherCallback;
import com.github.kuliginstepan.outbox.core.ReactiveRepublisherCallbackAdapter;
import com.github.kuliginstepan.outbox.relational.autoconfigure.CommonOutboxConfiguration;
import com.github.kuliginstepan.outbox.relational.autoconfigure.ExtendedRelationalOutboxProperties;
import com.github.kuliginstepan.outbox.relational.autoconfigure.R2dbcOutboxRepository;
import com.github.kuliginstepan.outbox.relational.autoconfigure.R2dbcOutboxScriptDatabaseInitializer;
import io.r2dbc.spi.ConnectionFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.autoconfigure.r2dbc.R2dbcAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.r2dbc.core.DatabaseClient;
import reactor.core.scheduler.Schedulers;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={R2dbcAutoConfiguration.class, JacksonAutoConfiguration.class})
@Import(value={CommonOutboxConfiguration.class})
@ConditionalOnClass(value={DatabaseClient.class, ObjectMapper.class})
public class R2dbcOutboxAutoConfiguration {
    private final ExtendedRelationalOutboxProperties properties;

    @Bean
    @ConditionalOnMissingBean
    public ReactiveOutboxRepository r2dbcOutboxRepository(DatabaseClient databaseClient, ObjectMapper mapper) {
        return new R2dbcOutboxRepository(databaseClient, mapper, this.properties.getRelational());
    }

    @Bean
    @ConditionalOnMissingBean
    public ReactiveRepublisherCallback reactiveRepublisherCallback() {
        return new ReactiveRepublisherCallbackAdapter();
    }

    @Bean
    @ConditionalOnMissingBean
    public ReactiveOutboxAspect r2dbcOutboxAspect(OutboxEntityFactory factory, ReactiveOutboxRepository repository) {
        return new ReactiveOutboxAspect(factory, repository, Schedulers.boundedElastic());
    }

    @Bean
    @ConditionalOnMissingBean
    public ReactiveOutboxRepublisher r2dbcOutboxRepublisher(ReactiveOutboxRepository repository, ReactiveRepublisherCallback callback) {
        return new DefaultReactiveOutboxRepublisher(repository, callback, this.properties.getNotAfterPolicy());
    }

    @Bean
    @ConditionalOnMissingBean
    public ReactiveOutboxPersistenceManager r2dbcOutboxPersistenceManager(ReactiveOutboxRepository repository) {
        return new DefaultReactiveOutboxPersistenceManager(repository, this.properties.getCompletedEventsPersistencePeriod());
    }

    @Bean
    public R2dbcOutboxScriptDatabaseInitializer r2dbcOutboxScriptDatabaseInitializer(ConnectionFactory factory) {
        return new R2dbcOutboxScriptDatabaseInitializer(factory, this.properties.getRelational());
    }

    public R2dbcOutboxAutoConfiguration(ExtendedRelationalOutboxProperties properties) {
        this.properties = properties;
    }
}

