/*
 * Decompiled with CFR 0.152.
 */
package com.github.kuliginstepan.outbox.relational.autoconfigure;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.kuliginstepan.outbox.core.OutboxEntity;
import com.github.kuliginstepan.outbox.core.OutboxMethodIdentifier;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Arrays;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.ClassUtils;

class OutboxEntityRowMapper
implements RowMapper<OutboxEntity> {
    private final ObjectMapper mapper;

    public OutboxEntity mapRow(ResultSet rs, int rowNum) throws SQLException {
        final String id = rs.getString("ID");
        final OutboxMethodIdentifier methodIdentifier = OutboxMethodIdentifier.of((String)rs.getString("OUTBOX_METHOD_ID"));
        final String dataType = rs.getString("DATA_TYPE");
        final String data = rs.getString("DATA");
        final Instant publicationDate = Instant.ofEpochMilli(rs.getLong("PUBLICATION_DATE"));
        return new OutboxEntity(){

            public String getId() {
                return id;
            }

            public Instant getPublicationDate() {
                return publicationDate;
            }

            public OutboxMethodIdentifier getMethodIdentifier() {
                return methodIdentifier;
            }

            public Object[] getData() {
                Class[] dataTypes = (Class[])Arrays.stream(dataType.split(",")).map(type -> ClassUtils.resolveClassName((String)type, null)).toArray(Class[]::new);
                Object[] objects = OutboxEntityRowMapper.this.deserialize(data, Object[].class);
                for (int i = 0; i < objects.length; ++i) {
                    objects[i] = OutboxEntityRowMapper.this.mapper.convertValue(objects[i], dataTypes[i]);
                }
                return objects;
            }
        };
    }

    private <T> T deserialize(String data, Class<T> type) {
        try {
            return (T)this.mapper.readValue(data, type);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public OutboxEntityRowMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }
}

