/*
 * Decompiled with CFR 0.152.
 */
package com.github.kuliginstepan.outbox.relational.autoconfigure;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.kuliginstepan.outbox.core.OutboxEntity;
import com.github.kuliginstepan.outbox.core.OutboxRepository;
import com.github.kuliginstepan.outbox.relational.autoconfigure.ExtendedRelationalOutboxProperties;
import com.github.kuliginstepan.outbox.relational.autoconfigure.OutboxEntityRowMapper;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class JdbcOutboxRepository
implements OutboxRepository {
    private static final String INSERT_QUERY = "INSERT INTO %TABLE_NAME% (ID, PUBLICATION_DATE, OUTBOX_METHOD_ID, DATA_TYPE, DATA) VALUES (?, ?, ?, ?, ?)";
    private static final String MARK_COMPLETED_QUERY = "UPDATE %TABLE_NAME% SET COMPLETION_DATE = ? WHERE ID = ? AND COMPLETION_DATE IS NULL";
    private static final String DELETE_COMPLETED_QUERY = "DELETE FROM %TABLE_NAME% WHERE COMPLETION_DATE IS NOT NULL AND PUBLICATION_DATE <= ?";
    private static final String SELECT_UNCOMPLETED_QUERY = "SELECT * FROM %TABLE_NAME% WHERE COMPLETION_DATE IS NULL AND PUBLICATION_DATE <= ?";
    private final JdbcTemplate template;
    private final ObjectMapper mapper;
    private final RowMapper<OutboxEntity> rowMapper;
    private final String insertQuery;
    private final String markCompletedQuery;
    private final String deleteCompletedQuery;
    private final String selectUncompletedQuery;

    public JdbcOutboxRepository(JdbcTemplate template, ObjectMapper mapper, ExtendedRelationalOutboxProperties.RelationalOutboxProperties properties) {
        this.template = template;
        this.mapper = mapper;
        this.rowMapper = new OutboxEntityRowMapper(mapper);
        this.insertQuery = this.getQuery(INSERT_QUERY, properties.getTable());
        this.markCompletedQuery = this.getQuery(MARK_COMPLETED_QUERY, properties.getTable());
        this.deleteCompletedQuery = this.getQuery(DELETE_COMPLETED_QUERY, properties.getTable());
        this.selectUncompletedQuery = this.getQuery(SELECT_UNCOMPLETED_QUERY, properties.getTable());
    }

    public void save(OutboxEntity entity) {
        this.template.update(this.insertQuery, new Object[]{entity.getId(), entity.getPublicationDate().toEpochMilli(), entity.getMethodIdentifier().getValue(), this.serialize(entity.getData()), Arrays.stream(entity.getData()).map(Object::getClass).map(ClassUtils::getQualifiedName).collect(Collectors.joining(","))});
    }

    public void markCompleted(OutboxEntity entity) {
        this.template.update(this.markCompletedQuery, new Object[]{Instant.now().toEpochMilli(), entity.getId()});
    }

    public void deleteCompletedEntities(Instant notAfterDate) {
        this.template.update(this.deleteCompletedQuery, new Object[]{notAfterDate.toEpochMilli()});
    }

    public List<OutboxEntity> findUncompletedEntities(Instant notAfterDate) {
        return this.template.query(this.selectUncompletedQuery, this.rowMapper, new Object[]{notAfterDate.toEpochMilli()});
    }

    private String serialize(Object o) {
        try {
            return this.mapper.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private String getQuery(String base, String tableName) {
        return StringUtils.replace((String)base, (String)"%TABLE_NAME%", (String)tableName);
    }
}

