/*
 * Decompiled with CFR 0.152.
 */
package com.github.kuliginstepan.outbox.relational.autoconfigure;

import com.github.kuliginstepan.outbox.relational.autoconfigure.ExtendedRelationalOutboxProperties;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.boot.jdbc.init.DataSourceScriptDatabaseInitializer;
import org.springframework.boot.jdbc.init.PlatformPlaceholderDatabaseDriverResolver;
import org.springframework.boot.sql.init.DatabaseInitializationSettings;
import org.springframework.util.StringUtils;

public class JdbcOutboxDataSourceScriptDatabaseInitializer
extends DataSourceScriptDatabaseInitializer {
    public JdbcOutboxDataSourceScriptDatabaseInitializer(DataSource dataSource, ExtendedRelationalOutboxProperties.RelationalOutboxProperties properties) {
        this(dataSource, JdbcOutboxDataSourceScriptDatabaseInitializer.getSettings(dataSource, properties));
    }

    public JdbcOutboxDataSourceScriptDatabaseInitializer(DataSource dataSource, DatabaseInitializationSettings settings) {
        super(dataSource, settings);
    }

    static DatabaseInitializationSettings getSettings(DataSource dataSource, ExtendedRelationalOutboxProperties.RelationalOutboxProperties properties) {
        DatabaseInitializationSettings settings = new DatabaseInitializationSettings();
        settings.setSchemaLocations(JdbcOutboxDataSourceScriptDatabaseInitializer.resolveSchemaLocations(dataSource, properties));
        settings.setMode(properties.getInitializeSchema());
        settings.setContinueOnError(true);
        return settings;
    }

    private static List<String> resolveSchemaLocations(DataSource dataSource, ExtendedRelationalOutboxProperties.RelationalOutboxProperties properties) {
        PlatformPlaceholderDatabaseDriverResolver platformResolver = new PlatformPlaceholderDatabaseDriverResolver();
        if (StringUtils.hasText((String)properties.getPlatform())) {
            return platformResolver.resolveAll(properties.getPlatform(), new String[]{properties.getSchema()});
        }
        return platformResolver.resolveAll(dataSource, new String[]{properties.getSchema()});
    }
}

