/*
 * Decompiled with CFR 0.152.
 */
package com.github.kuliginstepan.outbox.relational.autoconfigure;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.kuliginstepan.outbox.core.DefaultOutboxPersistenceManager;
import com.github.kuliginstepan.outbox.core.DefaultOutboxRepublisher;
import com.github.kuliginstepan.outbox.core.OutboxAspect;
import com.github.kuliginstepan.outbox.core.OutboxEntityFactory;
import com.github.kuliginstepan.outbox.core.OutboxPersistenceManager;
import com.github.kuliginstepan.outbox.core.OutboxRepository;
import com.github.kuliginstepan.outbox.core.OutboxRepublisher;
import com.github.kuliginstepan.outbox.core.RepublisherCallback;
import com.github.kuliginstepan.outbox.core.RepublisherCallbackAdapter;
import com.github.kuliginstepan.outbox.relational.autoconfigure.CommonOutboxConfiguration;
import com.github.kuliginstepan.outbox.relational.autoconfigure.ExtendedRelationalOutboxProperties;
import com.github.kuliginstepan.outbox.relational.autoconfigure.JdbcOutboxDataSourceScriptDatabaseInitializer;
import com.github.kuliginstepan.outbox.relational.autoconfigure.JdbcOutboxRepository;
import javax.sql.DataSource;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={JdbcTemplateAutoConfiguration.class, JacksonAutoConfiguration.class})
@Import(value={CommonOutboxConfiguration.class})
@ConditionalOnClass(value={JdbcTemplate.class, ObjectMapper.class})
public class JdbcOutboxAutoConfiguration {
    private final ExtendedRelationalOutboxProperties properties;

    @Bean
    @ConditionalOnMissingBean
    public OutboxRepository jdbcOutboxRepository(JdbcTemplate template, ObjectMapper mapper) {
        return new JdbcOutboxRepository(template, mapper, this.properties.getRelational());
    }

    @Bean
    @ConditionalOnMissingBean
    public RepublisherCallback republisherCallback() {
        return new RepublisherCallbackAdapter();
    }

    @Bean
    @ConditionalOnMissingBean
    public OutboxAspect outboxAspect(OutboxEntityFactory factory, OutboxRepository repository, ObjectProvider<ThreadPoolTaskExecutor> executor) {
        return new OutboxAspect(factory, repository, (TaskExecutor)executor.getIfAvailable(() -> {
            ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
            taskExecutor.initialize();
            return taskExecutor;
        }));
    }

    @Bean
    @ConditionalOnMissingBean
    public OutboxRepublisher jdbcOutboxRepublisher(OutboxRepository repository, RepublisherCallback callback) {
        return new DefaultOutboxRepublisher(repository, callback, this.properties.getNotAfterPolicy());
    }

    @Bean
    @ConditionalOnMissingBean
    public OutboxPersistenceManager jdbcOutboxPersistenceManager(OutboxRepository repository) {
        return new DefaultOutboxPersistenceManager(repository, this.properties.getCompletedEventsPersistencePeriod());
    }

    @Bean
    public JdbcOutboxDataSourceScriptDatabaseInitializer jdbcOutboxDataSourceScriptDatabaseInitializer(DataSource dataSource) {
        return new JdbcOutboxDataSourceScriptDatabaseInitializer(dataSource, this.properties.getRelational());
    }

    public JdbcOutboxAutoConfiguration(ExtendedRelationalOutboxProperties properties) {
        this.properties = properties;
    }
}

