package com.github.kuliginstepan.outbox.core;

import reactor.core.publisher.Mono;

public interface ReactiveRepublisherCallback {

    Mono<Void> beforeRepublish();

    Mono<Void> beforeEntityRepublish(OutboxEntity entity);

    Mono<Void> afterEntityRepublish(OutboxEntity entity);

    Mono<Void> onEntityRepublishException(OutboxEntity entity, Exception e);

    Mono<Void> afterRepublish();
}
