package com.github.kuliginstepan.outbox.core;

import java.time.Instant;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveOutboxRepository {

    Mono<Void> save(OutboxEntity entity);

    Mono<Void> markCompleted(OutboxEntity entity);

    Mono<Void> deleteCompletedEntities(Instant notAfterDate);

    Flux<OutboxEntity> findUncompletedEntities(Instant notAfterDate);
}
