package com.github.kuliginstepan.outbox.core;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.task.TaskExecutor;
import org.springframework.transaction.support.TransactionSynchronization;

@Slf4j
@RequiredArgsConstructor
class OutboxTransactionSynchronization implements TransactionSynchronization {

    private final OutboxRepository repository;
    private final OutboxEntity entity;
    private final TaskExecutor executor;
    private final MethodInvoker invoker;

    @Override
    public void afterCommit() {
        executor.execute(() -> {
            try {
                log.debug("Invoking outbox method: {}, args: {}", invoker.getMethod(), invoker.getArgs());
                invoker.invoke();
                log.debug("Outbox method {} successfully invoked", invoker.getMethod());
                repository.markCompleted(entity);
                log.debug("Outbox method {} marked as completed", invoker.getMethod());
            } catch (Exception e) {
                log.error("Outbox method {} invoked with error", invoker.getMethod(), e);
            }
        });
    }
}
