package com.github.kuliginstepan.outbox.core;

import java.lang.reflect.Method;
import lombok.Value;
import org.springframework.util.ReflectionUtils;

@Value
class MethodInvoker {

    Method method;
    Object target;
    Object[] args;

    public MethodInvoker(Method method, Object target, Object[] args) {
        this.method = method;
        this.target = target;
        this.args = args;
    }

    public Object invoke() {
        ReflectionUtils.makeAccessible(method);
        return ReflectionUtils.invokeMethod(method, target, args);
    }
}
