package com.github.kuliginstepan.outbox.core;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.util.concurrent.TimeUnit;
import lombok.RequiredArgsConstructor;
import org.springframework.scheduling.annotation.Scheduled;
import reactor.core.publisher.Mono;

@RequiredArgsConstructor
public class DefaultReactiveOutboxPersistenceManager implements ReactiveOutboxPersistenceManager {

    private final ReactiveOutboxRepository repository;
    private final Period persistencePeriod;

    @Override
    public Mono<Void> clean() {
        return repository.deleteCompletedEntities(
            LocalDateTime.of(LocalDate.now().minus(persistencePeriod), LocalTime.now())
                .atZone(ZoneId.systemDefault())
                .toInstant()
        );
    }

    @Scheduled(fixedDelay = 1, timeUnit = TimeUnit.HOURS)
    public void scheduledClean() {
        clean().block();
    }
}
