package com.github.kuliginstepan.outbox.core;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.util.concurrent.TimeUnit;
import lombok.RequiredArgsConstructor;
import org.springframework.scheduling.annotation.Scheduled;

@RequiredArgsConstructor
public class DefaultOutboxPersistenceManager implements OutboxPersistenceManager {

    private final OutboxRepository repository;
    private final Period persistencePeriod;

    @Override
    @Scheduled(fixedDelay = 1, timeUnit = TimeUnit.HOURS)
    public void clean() {
        repository.deleteCompletedEntities(
            OffsetDateTime.ofInstant(Instant.now(), ZoneId.systemDefault()).minus(persistencePeriod).toInstant()
        );
    }
}
