/*
 * Decompiled with CFR 0.152.
 */
package com.github.krr.mongodb.aggregate.support.factory;

import com.github.krr.mongodb.aggregate.support.api.ReactiveMongoQueryExecutor;
import com.github.krr.mongodb.aggregate.support.factory.ReactiveAggregateQuerySupportingRepositoryFactory;
import java.io.Serializable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.repository.support.ReactiveMongoRepositoryFactoryBean;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class ReactiveAggregateQuerySupportingRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends ReactiveMongoRepositoryFactoryBean<T, S, ID>
implements ApplicationContextAware {
    private final ReactiveMongoQueryExecutor queryExecutor;
    private final Environment environment;
    private ApplicationContext applicationContext;

    @Autowired
    public ReactiveAggregateQuerySupportingRepositoryFactoryBean(Class<? extends T> repositoryInterface, ReactiveMongoQueryExecutor queryExecutor, Environment environment) {
        super(repositoryInterface);
        this.queryExecutor = queryExecutor;
        this.environment = environment;
    }

    @NonNull
    protected RepositoryFactorySupport getFactoryInstance(@NonNull ReactiveMongoOperations operations) {
        Assert.notNull((Object)this.queryExecutor, (String)"Query executor cannot be null");
        return new ReactiveAggregateQuerySupportingRepositoryFactory(operations, this.queryExecutor, this.applicationContext, this.environment);
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

