/*
 * Decompiled with CFR 0.152.
 */
package com.github.krr.mongodb.aggregate.support.factory;

import com.github.krr.mongodb.aggregate.support.annotations.Aggregate;
import com.github.krr.mongodb.aggregate.support.api.ReactiveMongoQueryExecutor;
import com.github.krr.mongodb.aggregate.support.query.ReactiveAggregateMongoQuery;
import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.repository.support.ReactiveMongoRepositoryFactory;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class ReactiveAggregateQuerySupportingRepositoryFactory
extends ReactiveMongoRepositoryFactory {
    private final ReactiveMongoOperations mongoOperations;
    private final ReactiveMongoQueryExecutor queryExecutor;
    private final ApplicationContext applicationContext;
    private final Environment environment;

    public ReactiveAggregateQuerySupportingRepositoryFactory(ReactiveMongoOperations mongoOperations, ReactiveMongoQueryExecutor queryExecutor, ApplicationContext applicationContext, Environment environment) {
        super(mongoOperations);
        this.mongoOperations = mongoOperations;
        this.queryExecutor = queryExecutor;
        this.applicationContext = applicationContext;
        this.environment = environment;
    }

    public Optional<QueryLookupStrategy> getQueryLookupStrategy(QueryLookupStrategy.Key key, @NonNull ValueExpressionDelegate valueExpressionDelegate) {
        Optional parentQueryLookupStrategy = super.getQueryLookupStrategy(key, valueExpressionDelegate);
        Assert.isTrue((boolean)parentQueryLookupStrategy.isPresent(), (String)"Expecting parent query lookup strategy to be present");
        return Optional.of(new AggregateQueryLookupStrategy((QueryLookupStrategy)parentQueryLookupStrategy.get()));
    }

    private boolean isAggregateQueryAnnotated(Method method) {
        return method.getAnnotation(Aggregate.class) != null;
    }

    private class AggregateQueryLookupStrategy
    implements QueryLookupStrategy {
        private final QueryLookupStrategy parentQueryLookupStrategy;

        AggregateQueryLookupStrategy(QueryLookupStrategy parentQueryLookupStrategy) {
            this.parentQueryLookupStrategy = parentQueryLookupStrategy;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata repositoryMetadata, ProjectionFactory projectionFactory, NamedQueries namedQueries) {
            if (!ReactiveAggregateQuerySupportingRepositoryFactory.this.isAggregateQueryAnnotated(method)) {
                return this.parentQueryLookupStrategy.resolveQuery(method, repositoryMetadata, projectionFactory, namedQueries);
            }
            return new ReactiveAggregateMongoQuery(method, repositoryMetadata, ReactiveAggregateQuerySupportingRepositoryFactory.this.mongoOperations, projectionFactory, ReactiveAggregateQuerySupportingRepositoryFactory.this.queryExecutor, ReactiveAggregateQuerySupportingRepositoryFactory.this.applicationContext, ReactiveAggregateQuerySupportingRepositoryFactory.this.environment);
        }
    }
}

