/*
 * Decompiled with CFR 0.152.
 */
package com.github.krr.mongodb.aggregate.support.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.krr.mongodb.aggregate.support.api.QueryProvider;
import com.github.krr.mongodb.aggregate.support.query.AbstractReactiveQueryExecutor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.configuration.CodecRegistries;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveMongoNativeJavaDriverQueryExecutor
extends AbstractReactiveQueryExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveMongoNativeJavaDriverQueryExecutor.class);
    private static final String MONGO_V3_6_VERSION = "3.6";

    public ReactiveMongoNativeJavaDriverQueryExecutor(ReactiveMongoOperations mongoOperations) {
        super(mongoOperations);
        this.initialize(mongoOperations);
    }

    public ReactiveMongoNativeJavaDriverQueryExecutor(ReactiveMongoOperations mongoOperations, ObjectMapper objectMapper) {
        super(mongoOperations, objectMapper);
        this.initialize(mongoOperations);
    }

    private void initialize(ReactiveMongoOperations mongoOperations) {
        Document result = (Document)mongoOperations.executeCommand("{buildinfo:1}").block();
    }

    @Override
    public Publisher<?> executeQuery(QueryProvider queryProvider) {
        boolean isFluxOrMono;
        Iterator iterator = queryProvider.getPipelines().iterator();
        int i = 0;
        String collectionName = queryProvider.getCollectionName();
        ArrayList<BsonDocument> pipelineStages = new ArrayList<BsonDocument>();
        while (iterator.hasNext()) {
            String query = (String)iterator.next();
            LOGGER.trace("Processing query string {} for pipeline stage {}", (Object)query, (Object)i++);
            BsonDocument document = BsonDocument.parse((String)query);
            pipelineStages.add(document);
        }
        Mono collectionMono = this.mongoOperations.getCollection(collectionName);
        Mono aggregatePublisherMono = collectionMono.map(collection -> collection.aggregate(pipelineStages).allowDiskUse(Boolean.valueOf(queryProvider.isAllowDiskUse())).maxTime(queryProvider.getMaxTimeMS(), TimeUnit.MILLISECONDS));
        Class methodReturnType = queryProvider.getMethodReturnType();
        boolean isFlux = Flux.class.isAssignableFrom(methodReturnType);
        boolean isMono = Mono.class.isAssignableFrom(methodReturnType);
        boolean bl = isFluxOrMono = isFlux || isMono;
        if (!isFluxOrMono) {
            throw new IllegalArgumentException("Method return type must be of Flux or Mono type");
        }
        Class outputClass = queryProvider.getOutputClass();
        if (isFlux) {
            LOGGER.trace("Return type is Flux<{}>", (Object)outputClass);
            Flux retval = aggregatePublisherMono.flatMapMany(ap -> ap);
            if (outputClass != null) {
                return this.adaptPipeline(queryProvider, outputClass, (Flux<Document>)retval);
            }
            return retval;
        }
        Mono mono = aggregatePublisherMono.flatMap(ap -> (Mono)ap.first());
        if (outputClass != null) {
            LOGGER.trace("Return type is Mono<{}>", (Object)outputClass);
            return this.adaptPipeline(queryProvider, outputClass, (Mono<Document>)mono);
        }
        return mono;
    }

    private Mono<?> adaptPipeline(QueryProvider queryProvider, Class<?> outputClass, Mono<Document> retval) {
        String key = queryProvider.getQueryResultKey();
        if (BeanUtils.isSimpleValueType(outputClass)) {
            return retval.map(d -> d.get((Object)key, outputClass)).doOnError(e -> LOGGER.error("Exception while extracting results from document for key {}", (Object)key, e));
        }
        return retval.map(d -> (Document)this.getDocumentForKey(key, (Document)d, false)).map(d -> d.toBsonDocument(Document.class, CodecRegistries.fromCodecs((Codec[])new Codec[]{new DocumentCodec()}))).map(d -> this.deserialize(outputClass, (BsonDocument)d)).doOnError(e -> LOGGER.error("Exception while extracting results from document for key {}", (Object)key, e));
    }

    private Object getDocumentForKey(String key, Document d, boolean isFlux) {
        Object o;
        if (StringUtils.isEmpty((CharSequence)key)) {
            LOGGER.debug("No key specified - will return document");
            return d;
        }
        if (isFlux && Iterable.class.isAssignableFrom((o = d.get((Object)key)).getClass())) {
            LOGGER.debug("Returning iterable document from query results for key {}", (Object)key);
            return o;
        }
        LOGGER.debug("Returning embedded document from query results for key {}", (Object)key);
        return d.get((Object)key);
    }

    private <T> Flux<T> adaptPipeline(QueryProvider queryProvider, Class<T> outputClass, Flux<Document> retval) {
        String key = queryProvider.getQueryResultKey();
        return retval.flatMapIterable(d -> this.getNestedDocumentList(key, (Document)d)).map(d -> d.toBsonDocument(Document.class, CodecRegistries.fromCodecs((Codec[])new Codec[]{new DocumentCodec()}))).map(d -> this.deserialize(outputClass, (BsonDocument)d)).doOnError(e -> LOGGER.error("Exception extracting results from document for key {}/output class {}", new Object[]{key, outputClass, e}));
    }

    private Iterable<? extends Document> getNestedDocumentList(String key, Document d) {
        Object object = this.getDocumentForKey(key, d, true);
        if (Iterable.class.isAssignableFrom(object.getClass())) {
            return (Iterable)object;
        }
        return Collections.singletonList((Document)object);
    }

    private <T> T deserialize(Class<T> outputClass, BsonDocument d) {
        try {
            return (T)this.objectMapper.readValue(d.toJson(), outputClass);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

