/*
 * Decompiled with CFR 0.152.
 */
package com.github.krr.mongodb.aggregate.support.query;

import com.github.krr.mongodb.aggregate.support.annotations.Aggregate;
import com.github.krr.mongodb.aggregate.support.api.QueryProvider;
import com.github.krr.mongodb.aggregate.support.api.ReactiveMongoQueryExecutor;
import com.github.krr.mongodb.aggregate.support.exceptions.InvalidAggregationQueryException;
import com.github.krr.mongodb.aggregate.support.exceptions.MongoQueryException;
import com.github.krr.mongodb.aggregate.support.query.AbstractAggregateQueryProvider;
import com.github.krr.mongodb.aggregate.support.query.ApplicationContextQueryMethodEvaluationContextProvider;
import com.github.krr.mongodb.aggregate.support.query.MongoAggregateQueryProvider;
import java.lang.reflect.Method;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.convert.MongoWriter;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.AbstractReactiveMongoQuery;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParametersParameterAccessor;
import org.springframework.data.mongodb.repository.query.ReactiveMongoQueryMethod;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.ReactiveQueryMethodEvaluationContextProvider;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

@Component
public class ReactiveAggregateMongoQuery
extends AbstractReactiveMongoQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveAggregateMongoQuery.class);
    private final ReactiveMongoOperations mongoOperations;
    private final Method method;
    private final ReactiveMongoQueryExecutor queryExecutor;
    private static final ReactiveQueryMethodEvaluationContextProvider CONTEXT_PROVIDER = new ApplicationContextQueryMethodEvaluationContextProvider();

    @Autowired
    public ReactiveAggregateMongoQuery(Method method, RepositoryMetadata metadata, ReactiveMongoOperations mongoOperations, ProjectionFactory projectionFactory, ReactiveMongoQueryExecutor queryExecutor) {
        super(new ReactiveMongoQueryMethod(method, metadata, projectionFactory, mongoOperations.getConverter().getMappingContext()), mongoOperations, (ExpressionParser)new SpelExpressionParser(), CONTEXT_PROVIDER);
        this.mongoOperations = mongoOperations;
        this.method = method;
        this.queryExecutor = queryExecutor;
    }

    public Publisher<Object> execute(Object[] parameters) {
        MongoParametersParameterAccessor mongoParameterAccessor = new MongoParametersParameterAccessor(this.getQueryMethod(), parameters);
        ConvertingParameterAccessor parameterAccessor = new ConvertingParameterAccessor((MongoWriter)this.mongoOperations.getConverter(), (MongoParameterAccessor)mongoParameterAccessor);
        try {
            AbstractAggregateQueryProvider aggregateQueryProvider = this.createAggregateQueryProvider((MongoParameterAccessor)mongoParameterAccessor, parameterAccessor);
            return this.queryExecutor.executeQuery((QueryProvider)aggregateQueryProvider);
        }
        catch (MongoQueryException e) {
            LOGGER.error("Error executing aggregate query", (Throwable)e);
            throw new IllegalStateException(e);
        }
        catch (InvalidAggregationQueryException e) {
            LOGGER.error("Invalid aggregation query", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    private AbstractAggregateQueryProvider createAggregateQueryProvider(MongoParameterAccessor mongoParameterAccessor, ConvertingParameterAccessor parameterAccessor) throws InvalidAggregationQueryException {
        Aggregate annotation = this.method.getAnnotation(Aggregate.class);
        Assert.notNull((Object)annotation, (String)"Aggregate must be specified on the method");
        return new MongoAggregateQueryProvider(this.method, mongoParameterAccessor, parameterAccessor);
    }

    protected Mono<Query> createQuery(ConvertingParameterAccessor accessor) {
        throw new UnsupportedOperationException("AggregateMongoQuery does not support createQuery");
    }

    protected boolean isCountQuery() {
        return false;
    }

    protected boolean isExistsQuery() {
        return false;
    }

    protected boolean isDeleteQuery() {
        return false;
    }

    protected boolean isLimiting() {
        return false;
    }
}

