/*
 * Decompiled with CFR 0.152.
 */
package com.github.krr.mongodb.aggregate.support.query;

import com.github.krr.mongodb.aggregate.support.annotations.Aggregate;
import com.github.krr.mongodb.aggregate.support.api.MongoQueryExecutor;
import com.github.krr.mongodb.aggregate.support.api.QueryProvider;
import com.github.krr.mongodb.aggregate.support.exceptions.InvalidAggregationQueryException;
import com.github.krr.mongodb.aggregate.support.exceptions.MongoQueryException;
import com.github.krr.mongodb.aggregate.support.query.AggregateQueryProvider;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.convert.MongoWriter;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.AbstractMongoQuery;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParametersParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class NonReactiveAggregateMongoQuery
extends AbstractMongoQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonReactiveAggregateMongoQuery.class);
    private final MongoOperations mongoOperations;
    private final Method method;
    private final MongoQueryExecutor queryExecutor;
    private QueryProvider<Pageable> queryProvider;

    @Autowired
    public NonReactiveAggregateMongoQuery(Method method, RepositoryMetadata metadata, MongoOperations mongoOperations, ProjectionFactory projectionFactory, MongoQueryExecutor queryExecutor) {
        super(new MongoQueryMethod(method, metadata, projectionFactory, mongoOperations.getConverter().getMappingContext()), mongoOperations);
        this.mongoOperations = mongoOperations;
        this.method = method;
        this.queryExecutor = queryExecutor;
    }

    public Object execute(Object[] parameters) {
        MongoParametersParameterAccessor mongoParameterAccessor = new MongoParametersParameterAccessor(this.getQueryMethod(), parameters);
        ConvertingParameterAccessor parameterAccessor = new ConvertingParameterAccessor((MongoWriter)this.mongoOperations.getConverter(), (MongoParameterAccessor)mongoParameterAccessor);
        try {
            this.queryProvider = this.createAggregateQueryProvider((MongoParameterAccessor)mongoParameterAccessor, parameterAccessor);
            return this.queryExecutor.executeQuery(this.queryProvider);
        }
        catch (MongoQueryException e) {
            LOGGER.error("Error executing aggregate query", (Throwable)e);
            throw new IllegalStateException(e);
        }
        catch (InvalidAggregationQueryException e) {
            LOGGER.error("Invalid aggregation query", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    private QueryProvider<Pageable> createAggregateQueryProvider(MongoParameterAccessor mongoParameterAccessor, ConvertingParameterAccessor parameterAccessor) throws InvalidAggregationQueryException {
        Aggregate annotation = this.method.getAnnotation(Aggregate.class);
        Assert.notNull((Object)annotation, (String)"Either Aggregate or Aggregate2 must be specified on the method");
        return new AggregateQueryProvider(this.method, mongoParameterAccessor, parameterAccessor);
    }

    protected Query createQuery(ConvertingParameterAccessor accessor) {
        throw new UnsupportedOperationException("AggregateMongoQuery does not support createQuery");
    }

    protected boolean isCountQuery() {
        return false;
    }

    protected boolean isExistsQuery() {
        return false;
    }

    protected boolean isDeleteQuery() {
        return false;
    }

    protected boolean isLimiting() {
        if (this.queryProvider != null) {
            return this.queryProvider.isLimiting() || this.queryProvider.isPageable();
        }
        return false;
    }
}

